/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
// written by Karsten Laux, August 1999

#ifndef _MUTEX_H_
#define _MUTEX_H_

#include <SDL/SDL_mutex.h>

namespace wftk {

///Mutex class.
class Mutex
{
 public:
  
  ///
  Mutex() { mutex = SDL_CreateMutex();}
  ///
  ~Mutex() { SDL_DestroyMutex(mutex); }

  /// Access the underlying SDL_mutex
  operator SDL_mutex*() {return mutex;}

  /// Release a mutex
  void release() { SDL_mutexV(mutex);}
  /// Grab a mutex
  void grab() { SDL_mutexP(mutex);}

 private:
  ///
  SDL_mutex* mutex;

};



}



#endif
  
