/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 2002 Malcolm Walker
  Based on code copyright  (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "application.h"
#include "pushbutton.h"
#include "painter.h"
#include "rootwindow.h"
#include "cornercontainer.h"
#include "debug.h"

#include <cstdio>
#include <cstdlib>
#include <cmath> // for sin()

using namespace wftk;

class Terrain : public CornerContainer
{
 protected:
  ///
  virtual void draw(Surface&, const Point&, const Region&);
 private:
  ///
  Point w2p(float, float, float);
};

class TerrainApp : public Application
{
 public:
  TerrainApp(int argc, char** argv) : 
    Application(argc, argv)
    {
      new RootWindow(800,600);
  
      RootWindow::instance()->setTitle("LIBWFTK Texture Demo");

      //eg fontloading ....
      // These fonts are used by several gui elements,
      // so you should slways load text_font and button_font when
      // using widgets from libwftk.
      Font::registry.load("text_font","wf_opal.ttf, 18, 0xF0F0F0, 0x101010");
      Font::registry.load("button_font","wf_opal.ttf, 18, 0xF0F0F0, 0x101010");

      Surface::registry.load("button170","button.png");
      Surface::registry.load("button170_pressed","button_pressed.png");
      
      Surface::registry.load("mud","mud_dried.png");
      Surface::registry.load("mud25","mud_dried_shade25.png");
      Surface::registry.load("mud50","mud_dried_shade50.png");
      Surface::registry.load("mud75","mud_dried_shade75.png");

      Terrain* terrain = new Terrain();
      RootWindow::instance()->pack(terrain);

      //a pushbutton
      PushButton* quit_button = new PushButton("Quit");
      terrain->pack(quit_button);
    
      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
      quit_button->clicked.connect(quitSlot());
    }
};

#define SIZE_X 15
#define SIZE_Y 15

Point 
Terrain::w2p(float x, float y, float z)
{ 
  int my = height();
  int mx = width() / 2;
  float scale_x = 40.0;
  float scale_y = 20.0; 
  float scale_z = 10.0;

  int _x = mx + (int)((x - y) * scale_x + 0.45);
  int _y = my - (int)((x + y) * scale_y + z * scale_z + 0.45);

  return Point(_x,_y);
}

void Terrain::draw(Surface& target, const Point& offset, const Region& r)
{
  Point p1,p2,p3,p4;

  Surface drawing(width(), height());
 
  float grid[SIZE_X][SIZE_Y];
  unsigned x,y;
  for(x = 0; x < SIZE_X; x++)
    {
      for(y = 0; y < SIZE_Y; y ++)
	{
	  grid [x][y] = sin(y/4 + x );
	}
    }

  //clear surface
  drawing.clear();
  
  float z1,z2,z3,z4;

  for(x = 0; x < SIZE_X-1; x++)
    for(y = 0; y < SIZE_Y-1; y ++)
      {
	z1 = grid[x][y+1];
	z2 = grid[x+1][y+1];
	z3 = grid[x][y];
	z4 = grid[x+1][y];

	p1 = w2p(x,y+1,grid[x][y+1]);
	p2 = w2p(x+1,y+1,grid[x+1][y+1]);
	p3 = w2p(x,y,grid[x][y]);
	p4 = w2p(x+1,y,grid[x+1][y]);
	
// 	cerr << p1 << endl;
// 	cerr << p2 << endl;
// 	cerr << p3 << endl;
// 	cerr << p4 << endl;
// 	cerr << endl;

	if(z1 > z2)
	  if(z3 > z4)
	    Surface::registry.find("mud")->textureBlit(drawing,p1,p2,p3,p4);
	  else
	    Surface::registry.find("mud25")->textureBlit(drawing,p1,p2,p3,p4);
	else	  
	  if(z3 > z4)
	    Surface::registry.find("mud50")->textureBlit(drawing,p1,p2,p3,p4);
	  else
	    Surface::registry.find("mud75")->textureBlit(drawing,p1,p2,p3,p4);

	
      }

  drawing.blit(target, offset, r);
}


int main (int argc, char **argv)
{
  Debug::init(Debug::GENERIC);

  return TerrainApp(argc, argv).exec();
}

