/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 2002 Malcolm Walker
  Based on code copyright  (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "slider.h"
#include "terminal.h"
#include "pushbutton.h"
#include "togglebutton.h"
#include "multilineedit.h"
#include "rootwindow.h"
#include "sample.h"
#include "debug.h"
#include "mixer.h"
#include "box.h"
#include "filler.h"

#include "quitcheck.h"

#include <sigc++/object_slot.h>

using namespace wftk;

#include <cstdio>
#include <iostream>

class SimpleApp : public QuitCheckApp
{
protected:
  Slider* slider1;
  Slider* slider2;
  Terminal* info;
  LineEdit* edit;

public:
  void setback1();
  void setback2();

  void slider1Value(int n)
  {
    slider1->setColor(Color(0,100,50,255-n%256));
  }

  void slider2Value(int n)
  { 
    info->scrollTo(n);
  }

  void scrollslot()
  {
    slider2->setRange(0,info->linesCount());
    slider2->setValue(info->currentLine());   
  }

  void addInfoText()
  {
    if(edit->getText().empty())
      return;

    info->addText(edit->getText());
    info->newline();
    edit->clearText();
  }

  SimpleApp(int argc, char** argv) : 
    QuitCheckApp(argc, argv)
    {
      std::cout << "starting up ..." <<std::endl;
      //do init here

      // uncomment / comment these lines to give openGL a try
      //RootWindow* back = new RootWindow(640,480,0,false,false,Surface(),SDL_OPENGL);
      RootWindow* back = new RootWindow(640, 480);

      RootWindow::instance()->setTitle("LIBWFTK Demo");

      // These font resources are used by various gui elements,
      // so you should always register text_font and button_font when
      // using wftk
      Font::registry.load("text_font","wf_opal.ttf, 17, 0xF0F0F0FF, 0x707070FF");
      Font::registry.load("button_font","wf_opal.ttf, 16, 0xE0E0F0FF, 0x607f70EE");

      if(Mixer::instance()->audioAvailable()) {
        // register this wav file as sample resource "press"
        // it is played whenever an button gets pressed
        Sample::registry.load("press","press.wav");
        // same as above for "release"
        Sample::registry.load("release","release.wav");
      }

      // Register two surfaces 
      Surface::registry.load("pool","pool.png");
      Surface::registry.load("background","background.png");

      RootWindow::instance()->setBackground("background");

      Box* main_box = new Box(Box::LEFT_TO_RIGHT);
      back->pack(main_box);

      Box* left_box = new Box(Box::TOP_TO_BOTTOM);
      main_box->packBack(left_box);

      //create your gui here
      left_box->packBack(new MultiLineEdit("Simple wftk Application\n"
					   "by Malcolm Walker\n"
					   "Code originally by Karsten Laux\n",
					   Font::registry.find("button_font")));

      Box* terminal_box = new Box(Box::LEFT_TO_RIGHT);
      left_box->packBack(terminal_box);
   
      info = new Terminal("This is a Terminal Widget.\n"
			  "You may type in here and use the scrollbar "
			  "on the right to scroll the content.\n",
			  Font::registry.find("button_font"),
			  false);
      info->scrolled.connect(slot(*this, &SimpleApp::scrollslot));
      info->setColor(Color(0,100,50,128));
      terminal_box->packBack(info);

      slider2 = new Slider(Slider::VERTICAL, 25);
      slider2->setColor(Color(50,200,100,128));
      slider2->setButtonColor("lightgrey");
      slider2->setRange(0,info->linesCount());
      slider2->setValue(info->currentLine());
      slider2->valueChanged.connect(slot(*this, &SimpleApp::slider2Value));
      terminal_box->packBack(slider2);

      Box *right_box = new Box(Box::TOP_TO_BOTTOM);
      main_box->packBack(right_box);

      Box *logo_box = new Box(Box::LEFT_TO_RIGHT);
      right_box->packBack(logo_box);

      logo_box->packBack(new Filler(Filler::HORIZONTAL));

      logo_box->packBack(new Widget("wftk_logo"));

      right_box->packBack(new Filler(Filler::VERTICAL));

      ToggleButton* change = new ToggleButton("Background");
      right_box->packBack(change);

      //a pushbutton
      PushButton* quit_button = new PushButton("Quit");
      right_box->packBack(quit_button);

      change->pressed.connect(slot(*this, &SimpleApp::setback1));
      change->released.connect(slot(*this, &SimpleApp::setback2));

      left_box->packBack(new Filler(Filler::VERTICAL));

      edit = new LineEdit("LineEdit Widget: type here as well!");
      edit->enterPressed.connect(slot(*this,&SimpleApp::addInfoText));
      left_box->packBack(edit);

      left_box->packBack(new Filler(Filler::VERTICAL));

      Box* slider_box = new Box(Box::LEFT_TO_RIGHT);
      left_box->packBack(slider_box);

      slider_box->packBack(new Filler(Filler::HORIZONTAL));

      slider1 = new Slider(Slider::HORIZONTAL);
      slider1->setColor(Color(0,100,50,128));
      slider1->setButtonColor("lightgrey");
      slider1->setRange(0,255);
      slider1->setValue(128);
      slider1->valueChanged.connect(slot(*this, &SimpleApp::slider1Value));
      slider_box->packBack(slider1);

      slider_box->packBack(new Filler(Filler::HORIZONTAL));

      left_box->packBack(new Filler(Filler::VERTICAL));
      left_box->packBack(new Filler(Filler::VERTICAL));
      left_box->packBack(new Filler(Filler::VERTICAL));

      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
      quit_button->clicked.connect(quitSlot());

      std::cerr << "Finished with constructor" << std::endl;
    }
};

void SimpleApp::setback1()
{
  RootWindow::instance()->setBackground("pool");
}

void SimpleApp::setback2()
{
  RootWindow::instance()->setBackground("background");
}
   
int main (int argc, char **argv)
{
  Debug::init(Debug::GENERIC);

  return SimpleApp(argc, argv).exec();
}
