/*
  libwftk - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 2003 Ron Steinke

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef QUIT_CHECK_H
#define QUIT_CHECK_H

#include "application.h"
#include "questionbox.h"

#include <sigc++/object_slot.h>

/// An application that asks for confirmation before quitting.
class QuitCheckApp : public wftk::Application
{
 public:
  QuitCheckApp(int argc, char** argv) : wftk::Application(argc, argv) {}

  // override default quit handler to pop up an event box
  virtual void quit(int exitcode)
    {
      wftk::QuestionBox d("Confirm","Really quit ?");
      d.setColor("darkgrey");
      d.exec(0, true); // blockin exec()
      if(d.getResult())
	  wftk::Application::quit(exitcode);
    }
};

#endif // QUIT_CHECK_H
