#!/usr/local/bin/perl
# Restore some domains from some file

$no_acl_check++;
$ENV{'WEBMIN_CONFIG'} ||= "/etc/webmin";
$ENV{'WEBMIN_VAR'} ||= "/var/webmin";
if ($0 =~ /^(.*\/)[^\/]+$/) {
	chdir($1);
	}
chop($pwd = `pwd`);
$0 = "$pwd/restore-domain.pl";
require './virtual-server-lib.pl';
$< == 0 || die "restore-domain.pl must be run as root";

$first_print = \&first_text_print;
$second_print = \&second_text_print;
$indent_print = \&indent_text_print;
$outdent_print = \&outdent_text_print;

# Parse command-line args
while(@ARGV > 0) {
	local $a = shift(@ARGV);
	if ($a eq "--source") {
		$src = shift(@ARGV);
		}
	elsif ($a eq "--feature") {
		local $f = shift(@ARGV);
		$config{$f} || die "Feature $f is not enabled";
		push(@rfeats, $f);
		}
	elsif ($a eq "--domain") {
		push(@rdoms, shift(@ARGV));
		}
	elsif ($a eq "--all-features") {
		@rfeats = grep { $config{$_} } @backup_features;
		}
	elsif ($a eq "--all-domains") {
		$all_doms = 1;
		}
	elsif ($a eq "--test") {
		$test = 1;
		}
	else {
		&usage();
		}
	}
$src || usage();
@rdoms || $all_doms || usage();
@rfeats || usage();
($mode) = &parse_backup_url($src);
$mode > 0 || -r $src || -d $src || die "Missing or invalid restore file";

# Find the selected domains
$cont = &backup_contents($src);
ref($cont) || die "Failed to read backup file : $cont";
(keys %$cont) || die "Nothing in backup file!";
if ($all_doms) {
	# All in backup
	@rdoms = keys %$cont;
	}
foreach $dname (@rdoms) {
	local $dinfo = &get_domain_by("dom", $dname);
	if ($dinfo) {
		push(@doms, $dinfo);
		}
	else {
		push(@doms, { 'dom' => $dname,
			      'missing' => 1 });
		}
	}

if ($test) {
	# Just tell the user what will be done
	print "The following servers will be restored :\n";
	foreach $d (@doms) {
		print "\t$d->{'dom'}\n";
		}
	print "\n";
	print "The following features will be restored :\n";
	foreach $f (@rfeats) {
		$fn = $text{"backup_feature_".$f} || $text{"feature_".$f};
		print "\t",($fn ? $fn." ($f)" : $f),"\n";
		}
	exit(0);
	}

# Do it!
&$first_print("Starting restore..");
$ok = &restore_domains($src, \@doms, \@rfeats);
&run_post_actions();
if ($ok) {
	&$second_print("Restore completed successfully.");
	}
else {
	&$second_print("Restore failed!");
	}

sub usage
{
print "Restores a Virtualmin backup, for the domains and features specified\n";
print "on the command line.\n";
print "\n";
print "usage: restore-domain.pl --source file\n";
print "                  [--test]\n";
print "                  [--domain name] | [--all-domains]\n";
print "                  [--feature name] | [--all-features]\n";
print "\n";
print "Multiple domains may be specified with multiple --domain parameters.\n";
print "Features must be specified using their short names, like web and dns.\n";
exit(1);
}

