# Functions for managing logrotate

$feature_depends{'logrotate'} = [ 'web' ];

sub require_logrotate
{
return if ($require_logrotate++);
&foreign_require("logrotate", "logrotate-lib.pl");
}

# setup_logrotate(&domain)
# Create logrotate entries for the server's access and error logs
sub setup_logrotate
{
&$first_print($text{'setup_logrotate'});
&require_logrotate();
&require_apache();

local $alog = &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'}, 0);
local $elog = &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'}, 1);
local @logs = &unique(grep { $_ } ($alog, $elog));
if (@logs) {
	local $parent = &logrotate::get_config_parent();
	local $apachectl = $apache::config{'apachectl_path'} ||
			   "apachectl";
	local $lconf = {
		       'file' => $parent->{'file'},
		       'name' => \@logs,
		       'members' => [
			{ 'name' => 'rotate',
			  'value' => $config{'logrotate_num'} || 5 },
			{ 'name' => 'weekly' },
			{ 'name' => 'compress' },
			{ 'name' => 'postrotate',
			  'script' => "$apachectl graceful" }
			]
		      };
	&logrotate::save_directive($parent, undef, $lconf);
	&flush_file_lines();
	&$second_print($text{'setup_done'});
	}
else {
	&$second_print($text{'setup_nolog'});
	}
}

# modify_logrotate(&domain, &olddomain)
# Adjust path if home directory has changed
sub modify_logrotate
{
if ($_[0]->{'home'} ne $_[1]->{'home'}) {
	&require_logrotate();
	&$first_print($text{'save_logrotate'});

	# Work out the *old* access log, which will have already been renamed
	local $oldalog = &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'});
	$oldalog =~ s/$_[0]->{'home'}/$_[1]->{'home'}/;
	local $lconf = &get_logrotate_section($oldalog);

	if ($lconf) {
		local $parent = &logrotate::get_config_parent();
		local $n;
		foreach $n (@{$lconf->{'name'}}) {
			$n =~ s/$_[1]->{'home'}/$_[0]->{'home'}/g;
			}
		&logrotate::save_directive($parent, $lconf, $lconf);
		&flush_file_lines();
		&$second_print($text{'setup_done'});
		}
	else {
		&$second_print($text{'setup_nologrotate'});
		}
	}
}

# delete_logrotate(&domain)
# Remove logrotate section for this domain
sub delete_logrotate
{
&require_logrotate();
&$first_print($text{'delete_logrotate'});
local $lconf = &get_logrotate_section($_[0]);
if ($lconf) {
	local $parent = &logrotate::get_config_parent();
	&logrotate::save_directive($parent, $lconf, undef);
	&flush_file_lines();
	&$second_print($text{'setup_done'});
	}
else {
	&$second_print($text{'setup_nologrotate'});
	}
}

# get_logrotate_section(&domain|log-file)
sub get_logrotate_section
{
&require_logrotate();
&require_apache();
local $alog = ref($_[0]) ? &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'})
			 : $_[0];
local $conf = &logrotate::get_config();
local ($c, $n);
foreach $c (@$conf) {
	foreach $n (@{$c->{'name'}}) {
		return $c if ($n eq $alog);
		}
	}
return undef;
}

# check_logrotate_clash()
# No need to check for clashes ..
sub check_logrotate_clash
{
return 0;
}

# backup_logrotate(&domain, file)
# Saves the log rotation section for this domain to a file
sub backup_logrotate
{
&$first_print($text{'backup_logrotatecp'});
local $lconf = &get_logrotate_section($_[0]);
if ($lconf) {
	local $lref = &read_file_lines($lconf->{'file'});
	local $l;
	open(FILE, ">$_[1]");
	foreach $l (@$lref[$lconf->{'line'} .. $lconf->{'eline'}]) {
		print FILE "$l\n";
		}
	close(FILE);
	&$second_print($text{'setup_done'});
	return 1;
	}
else {
	&$second_print($text{'setup_nologrotate'});
	return 0;
	}
}

# restore_logrotate(&domain, file)
sub restore_logrotate
{
&$first_print($text{'restore_logrotatecp'});
local $lconf = &get_logrotate_section($_[0]);
if ($lconf) {
	local $srclref = &read_file_lines($_[1]);
	local $dstlref = &read_file_lines($lconf->{'file'});
	&lock_file($lconf->{'file'});
	splice(@$dstlref, $lconf->{'line'}+1,
	       $lconf->{'eline'}-$lconf->{'line'}-1,
	       @$srclref[1 .. @$srclref-2]);
	&flush_file_lines();
	&unlock_file($lconf->{'file'});
	&$second_print($text{'setup_done'});
	return 1;
	}
else {
	&$second_print($text{'setup_nologrotate'});
	return 0;
	}
}

1;

