// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        about.h
//
// Purpose:     interface to about dialog
//
// Created:     25 Apr 94   Michael Pichler
//
// Changed:     29 Jun 94   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_about_h
#define harmony_widgets_about_h

#include "libwidgets.h"

#include <hyperg/hyperg/language.h>

#include <InterViews/enter-scope.h>
#ifdef iv_nls
class FontSet;
#else
class Font;
#endif
class Glyph;
class Image;
class ManagedWindow;
class Patch;
class PolyGlyph;


// Class About - about box
//
// style name: About
//
// style attributes:
//
// infofontbig       large font (default helvetica 17)
// infofontsmall     small font (default helvetica 12)
// infofontsetbig    large fontset (default empty)
// infofontsetsmall  small font set (default empty)
// iconpath          path of icons (need not end with '/')
// aboutlogo         file name of about logo (TIFF)
// hyperglogo        file name of Hyper-G logo (TIFF)
// hypergmask        file name of HG-logo mask (X-Bitmap, bit set on background)
//
// example for call:
//
// if (About::ismapped ())
//   About::unmap ();
// else
//   About::map (language, "The Hyper-G Client for X11/Unix",
//               "Version 0.8f\nof Mon 25th April 1994");


class About
{
  public:
    static void map(                    // create and map About dialog
      HgLanguage::Language lang,        //   language (for copyright)
      const char* description,          //   program description
      const char* version,              //   version (several lines, separated with '\n')
      const char* wintitle = 0,         //   window title (default provided)
      int biglogo = 0                   //   show big logo (default small icon)
    );

    static void unmap();                // unmap and destroy About dialog

    static int ismapped()               // check whether About is mapped
    { return aboutwin_ != 0; }

    static void clear();                // unmap and destroy About dialog and frees
                                        // fonts (need for locale switching)

    static void credits(Glyph*);
#ifdef iv_nls
    static const FontSet* getBigFontSet();
    static const FontSet* getSmallFontSet();
#else
    static const Font* getBigFont();
    static const Font* getSmallFont();
#endif
    static void toggleCard ();

  private:
    static void lookupFonts ();

    static ManagedWindow* aboutwin_;
    static float hleft_, hbottom_;
    static Glyph* crglyph_;
    static Patch* winpatch_;
    static Glyph* credits_;
    static PolyGlyph* crbox_;
    static PolyGlyph* bigbox_;
    static int crindex_;
    static int card_;
#ifdef iv_nls
    static const FontSet* bigfontset_;
    static const FontSet* smallfontset_;
#else
    static const Font* bigfont_;
    static const Font* smallfont_;
#endif
};

#endif
