/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <EditAttributesWindow.h>
#include <Strings.h>
#include <SchematicFrame.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qabstractlayout.h>

#include <iostream>

//----------------------------------------------------------------------------
EditAttributesWindow::EditAttributesWindow( QWidget* parent, const char* name )
    : QDialog(parent, name, TRUE),
    topLayout_(0),
    gridLayout_(0)
{
  setCaption( name );

  topLayout_ = new QVBoxLayout( this );
  QHBoxLayout* buttonLayout = new QHBoxLayout( 0 );
  gridLayout_ = new QGridLayout( 0 );

  topLayout_->addSpacing( 10 );
  topLayout_->addItem( gridLayout_ );
  topLayout_->addSpacing( 10 );
  topLayout_->addItem( buttonLayout );

  QString okLabel = Strings::translate( Strings::LabelOk );
  QString cancelLabel = Strings::translate( Strings::LabelCancel );
  QPushButton* ok = new QPushButton( okLabel, this );
  QPushButton* cancel = new QPushButton( cancelLabel, this );
  connect ( ok, SIGNAL( clicked() ),
            this, SLOT( ok() ) );
  connect ( cancel, SIGNAL( clicked() ),
            this, SLOT( cancel() ) );

  buttonLayout->addWidget( ok );
  buttonLayout->addWidget( cancel );

  resize( topLayout_->sizeHint() );

  labelList_.setAutoDelete( TRUE );
}

//----------------------------------------------------------------------------
EditAttributesWindow::~EditAttributesWindow()
{
  delete topLayout_;
}

//----------------------------------------------------------------------------
void EditAttributesWindow::destroyWidgets()
{
  QMap< QString, QLineEdit* >::Iterator it;
  for( it = lineEditMap_.begin(); it != lineEditMap_.end(); it++ )
    {
      delete (QLineEdit*) it.data();
      it.data() = 0;
    }
  lineEditMap_.clear();
  labelList_.clear();
}

//----------------------------------------------------------------------------
void EditAttributesWindow::ok()
{
  Component::Attribute* attribute;
  for( attribute = attributeList_->first(); attribute != 0; attribute = attributeList_->next() )
    {
      QLineEdit* edit = lineEditMap_[attribute->name_];
      attribute->value_ = (edit->text()).upper();
    }
  SchematicFrame::instance()->reDraw();
  close();
}

//----------------------------------------------------------------------------
void EditAttributesWindow::cancel()
{
  close();
}

//----------------------------------------------------------------------------
void EditAttributesWindow::setAttributeList( Component::AttributeList& list )
{
  attributeList_ = &list;
  destroyWidgets();
  gridLayout_->expand( list.count(), 5 );
  gridLayout_->addColSpacing( 0, 30 );
  gridLayout_->addColSpacing( 1, 100 );
  gridLayout_->addColSpacing( 2, 10 );
  gridLayout_->addColSpacing( 3, 100 );
  gridLayout_->addColSpacing( 4, 30 );
  Component::Attribute* attribute = 0;
  int row = 0;
  for( attribute = list.first(); attribute != 0; attribute = list.next() )
    {
      QLabel* label = new QLabel( this, "name" );
      labelList_.append( label );
      QString trName = Strings::translate( attribute->name_ );
      label->setText( trName );
      gridLayout_->addWidget( label, row, 1 );
      QLineEdit* edit = new QLineEdit( this, attribute->name_ );
      lineEditMap_[attribute->name_] = edit;
      edit->setText( attribute->value_ );
      gridLayout_->addWidget( edit, row, 3 );
      row++;
    }
  resize( topLayout_->sizeHint() );
}

