/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef TOOLBAR_H
#define TOOLBAR_H

#include <qtoolbar.h>
#include <qmainwindow.h>

class QToolButton;
class QComboBox;

class ToolBar : public QToolBar
{
  Q_OBJECT
public:
  ToolBar(const QString & label, QMainWindow*, QMainWindow::ToolBarDock = QMainWindow::Top, bool newLine = FALSE);
  virtual ~ToolBar();

  static ToolBar* instance();

  void initialize();

  bool isEditingMode() const;
  bool isDrawingMode() const;

  void addComponentCatagory(const QString& catagory);

  void updateToolbarIcons( bool enableIcons ) const;
  
private:
  void insertSeparator();


public slots:
  //slots used to keep toolbar in step with context popup menu
  void popupToggleLineSlot();
  void popupSelectionSlot();
  
private slots:
  void newCatagorySelectedSlot( int );

  void toggleGridSlot();
  void toggleComponentTextSlot();
  void toggleSelectionSlot();
  void toggleLineSlot();
  void rotateSymbolSlot();
  void sweepCircuitSlot();
  void deleteSlot();

private:
  static ToolBar* instance_;
  
  bool selectEnabled_;
  bool drawEnabled_;

  QToolButton* arrowTool_;
  QToolButton* lineTool_;
  QToolButton* gridTool_; 
  QToolButton* textTool_;
  QToolButton* rotateTool_;
  QToolButton* deleteTool_;
  QComboBox*   catagoryBox_;
};

#endif
