namespace eval system {
    # No private variables
}

# system::users  --
#
#   Method to return all of the active users of the system.
#   in use.
#
# Args
#
#   None.
#
# Returns
#
#   user_list - A Tcl list of all the active users in
#               the /etc/passwd file of *nix systems.

proc system::users { } {

    # Pull all of the users off the /etc/passwd file which
    # every system has.
    set user_list ""
    if [catch {open "[file join / etc passwd]" r} fhandle] {
	return
    } else {
	foreach line [split [read $fhandle] \n] {
	    append user_list "[lindex [split $line ":"] 0] "
	}
	close $fhandle
    }

    return $user_list
}

# system::groups  --
#
#   Method to return all the groups the application user is
#   a registered member of.
#
# Args
#
#   None.
#
# Returns
#
#   group_list - A Tcl list of all the groups the tkWorld(user)
#                is a member of in the /etc/group file on *nix
#                systems.

proc system::groups { } {

    # See if the groups command exists, otherwise build the list
    # manually from the /etc/group file.
    if [catch {exec which groups} cmd] {
	set group_list ""
	if [catch {open "[file join / etc group]" r} fhandle] {
	    return
	} else {
	    foreach line [split [read $fhandle] \n] {
		if [regexp $tkWorld(user) $line] {
		    append group_list "[lindex [split $line "::"] 0] "
		}
	    }
	    close $fhandle
	}
    } else {
	set group_list [exec $cmd]
    }

    return $group_list
}

# system::which  --
#
#   Method to find the path for the command
#
# Args
#
#   cmd - Command to check for existence and path.
#
# Returns
#
#   Path of the executable. Null if the command does not exist.

proc system::which { cmd_list } {
    global env tkWorld

    # Initialize the found list.
    set found_list ""

    # Determine if the current system has the command in
    # the users path.
    foreach cmd $cmd_list {
	foreach p [split $env(PATH) :] {
	    if [catch {file type $p} type] {
		# Probably couldn't stat the file meaning we don't
		# have permission to perform this operation.
		continue
	    } elseif {$type == "link"} {
		# Skip links since we want the base executable for
		# tkWorld.
		continue
	    } elseif ![string length $p] {
		# Skip null paths which appear in the env(PATH) list.
		continue
	    }

	    # Steal the dot directory which means look in
	    # the current working directory.
	    if {$p == "."} {
		set p $tkWorld(working_dir)
	    }

	    # After all of that, see if the file exists in the
	    # current path element being searched.
	    if [file exists [set p [file join $p $cmd]]] {
		append found_list "$p "
	    }
	}
    }

    # Send back the list of all of the paths for the requested
    # commands that were sent to this procedure.
    return $found_list
}
