namespace eval registry {
    variable registry
}

# registry::create  --
#
#   Method to create the registry frame with a label and
#   scrolled listbox.
#
# Args
#
#   w - The parent window of the frame.
#
# Returns
#
#   The parent window of the frame.

proc registry::create { w } {
    # No private variables

    # Steal the toplevel parent directory.
    if {$w == "."} {
	set w {}
    } else {
	frame $w \
		-class Registry
    }

    # Build the label
    label $w.label \
	    -text Registry \
	    -font $gui::gui(font.label)

    # Define the listbox frame.
    scroll_listbox::create $w.listboxframe 10
    
    # Build the frame.
    grid $w.label \
	    -row 0 \
	    -column 0 \
	    -sticky ew \
	    -padx 0 \
	    -pady 0
    grid $w.listboxframe \
	    -row 1 \
	    -column 0 \
	    -sticky news \
	    -padx 0 \
	    -pady 0
    grid rowconfigure $w 0 -weight 0
    grid rowconfigure $w 1 -weight 1
    grid columnconfigure $w 0 -weight 0
    
    return $w
}

# registry::interior  --
#
#   Method to return the widget identifier for the listbox.
#
# Args
#
#   w - The registry's parent window
#
# Returns
#
#   The listbox widget path.

proc registry::interior { w } {
    # No private variables

    # Return the listbox.
    return $w.listboxframe.list
}

# registry::execute  --
#
#   Method to execute the create statement of the chosen registry
#   item.
#
# Args
#
#   idx - Index of the selected item in the registry listbox.
#
# Returns
#
#   None.

proc registry::execute { idx } {
    global tkWorld

    # Set the command to execute to be the create method of the
    # selected object (i.e. grep::create if grep is selected).
    set cmd "[$tkWorld(reg_listbox) get $idx]::create"
    
    # Run the command xxx::create which all elements in the
    # registry will have this method.
    eval $cmd
}

# registry::load  --
#
#   Method to load the reference to the executable elements
#   into the registry.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc registry::load { } {
    global tkWorld

    set registry(file_list) [lsort [glob -nocomplain \
	    [file join $tkWorld(registry_dir) *.tcl]]]

    foreach f $registry(file_list) {
	# Build the registry element without the /dir/dir/file.tcl
	# stuff on it.  All we want is file.
	regsub "[file dirname $f]/" $f "" cmd
	regsub "\.tcl" $cmd "" cmd

	# Insert the command in the registry.
	$tkWorld(reg_listbox) insert end $cmd

	# Bind the command to execute the clicked on command.
	bind $tkWorld(reg_listbox) <ButtonRelease-1> \
		{registry::execute [$tkWorld(reg_listbox) curselection]}
    }
}
