namespace eval file {
    # No private variables
}

# file::select --
#
#   Method to select a file(s).
#
# Args
#
#   type    - The list of file types
#   initdir - The initial directory.
#
# Returns
#
#   The selected file with a blank attached to it at the end so
#   users can perform repeated selections.

proc file::select { {type ""} {initdir ""} } {
    global tkWorld

    if ![string length $type] {
	set type {
	    {"All Files" {*}}
	    {"Text" {.txt}}
	}
    }
    if ![string length $initdir] {
	set initdir $tkWorld(working_dir)
    }
    
    return "[tk_getOpenFile \
		-filetypes $type \
		-initialdir $initdir \
		-title "File Select"] "
}