# $Id: filetransfer.tcl,v 1.27 2004/07/10 20:05:04 aleksey Exp $

namespace eval ft {
    
    custom::defgroup FileTransfer [::msgcat::mc "File Transfer options."] \
	-group Tkabber

    switch -- $::tcl_platform(platform) {
	windows {
	    if {[info exists $::env(TEMP)]} {
		set default_dir $::env(TEMP)
	    } else {
		set default_dir "C:\\TEMP"
	    }
	}
	default {
	    set default_dir "/tmp"
	}
    }
    # TODO macintosh?
    custom::defvar options(download_dir) $default_dir \
	[::msgcat::mc "Default directory for downloaded files."] \
	-type string -group FileTransfer

    custom::defvar options(cascaded_menu) 0 \
	[::msgcat::mc "Use cascaded (otherwise flat) file transfer menu."] \
	-type boolean -group FileTransfer

    plugins::load [file join plugins filetransfer] -uplevel 1
}


proc ft::create_menu {m jid args} {
    variable options
    
    if {$options(cascaded_menu)} {
	set mm [menu $m.filetransfer -tearoff 0]
	eval { hook::run create_filetransfer_menu_hook $mm 1 $jid } $args
	if {![hook::is_flag create_filetransfer_menu_hook transport]} {
	    $m add cascad -label [::msgcat::mc "Send file"] -menu $mm
	}
    } else {
	eval { hook::run create_filetransfer_menu_hook $m 0 $jid } $args
    }
    
}


