/*
 * File ufs.h
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it would be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Further, this software is distributed without any warranty that it is
 * free of the rightful claim of any third person regarding infringement
 * or the like.  Any license provided herein, whether implied or
 * otherwise, applies only to this software file.  Patent licenses, if
 * any, provided herein do not apply to combinations of this program with
 * other software, or any other product whatsoever.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write the Free Software Foundation, Inc., 59
 * Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 */

#define UFS_MAX_GROUP_LOADED 8
#define UFS_CGNO_EMPTY ((unsigned)-1)
#define	UFS_MAXNAMLEN 255
#define UFS_MAXMNTLEN 512
#define UFS_MAXCSBUFS 31

struct ufs_csum {
	uint32_t	cs_ndir;	/* number of directories */
	uint32_t	cs_nbfree;	/* number of free blocks */
	uint32_t	cs_nifree;	/* number of free inodes */
	uint32_t	cs_nffree;	/* number of free frags */
};

/*
 * Sizes of this structures are:
 *	ufs_super_block_first	512
 *	ufs_super_block_second	512
 *	ufs_super_block_third	356
 */
struct ufs_super_block_first {
	uint32_t	fs_link;	/* 0x00 */
	uint32_t	fs_rlink;	/* 0x04 */
	uint32_t	fs_sblkno;	/* 0x08 */
	uint32_t	fs_cblkno;	/* 0x0c */
	uint32_t	fs_iblkno;	/* 0x10 */
	uint32_t	fs_dblkno;	/* 0x14 */
	uint32_t	fs_cgoffset;	/* 0x18 */
	uint32_t	fs_cgmask;	/* 0x1c */
	uint32_t	fs_time;	/* 0x20 */
	uint32_t	fs_size;	/* 0x24 */
	uint32_t	fs_dsize;	/* 0x28 */
	uint32_t	fs_ncg;		/* 0x2c */
	uint32_t	fs_bsize;	/* 0x30 */
	uint32_t	fs_fsize;	/* 0x34 */
	uint32_t	fs_frag;	/* 0x38 */
	uint32_t	fs_minfree;	/* 0x3c */
	uint32_t	fs_rotdelay;	/* 0x40 */
	uint32_t	fs_rps;		/* 0x44 */
	uint32_t	fs_bmask;	/* 0x48 */
	uint32_t	fs_fmask;	/* 0x4c */
	uint32_t	fs_bshift;	/* 0x50 */
	uint32_t	fs_fshift;	/* 0x54 */
	uint32_t	fs_maxcontig;	/* 0x58 */
	uint32_t	fs_maxbpg;	/* 0x5c */
	uint32_t	fs_fragshift;	/* 0x60 */
	uint32_t	fs_fsbtodb;	/* 0x64 */
	uint32_t	fs_sbsize;	/* 0x68 */
	uint32_t	fs_csmask;	/* 0x6c */
	uint32_t	fs_csshift;	/* 0x70 */
	uint32_t	fs_nindir;	/* 0x74 */
	uint32_t	fs_inopb;	/* 0x78 */
	uint32_t	fs_nspf;	/* 0x7c */
	uint32_t	fs_optim;	/* 0x80 */
	union {
		struct {
			uint32_t	fs_npsect;
		} fs_sun;
		struct {
			int32_t	fs_state;
		} fs_sunx86;
	} fs_u1;			/* 0x84 */
	uint32_t	fs_interleave;	/* 0x88 */
	uint32_t	fs_trackskew;	/* 0x8c */
	uint32_t	fs_id[2];	/* 0x90 */
	uint32_t	fs_csaddr;	/* 0x98 */
	uint32_t	fs_cssize;	/* 0x9c */
	uint32_t	fs_cgsize;	/* 0xa0 */
	uint32_t	fs_ntrak;	/* 0xa4 */
	uint32_t	fs_nsect;	/* 0xa8 */
	uint32_t	fs_spc;		/* 0xac */
	uint32_t	fs_ncyl;	/* 0xb0 */
	uint32_t	fs_cpg;		/* 0xb4 */
	uint32_t	fs_ipg;		/* 0xb8 */
	uint32_t	fs_fpg;		/* 0xbc */
	struct ufs_csum fs_cstotal;	/* 0xc0 */
	uint8_t	fs_fmod;		/* 0xc4 */
	uint8_t	fs_clean;		/* 0xc8 */
	uint8_t	fs_ronly;		/* 0xcc */
	uint8_t	fs_flags;		/* 0xd0 */
	uint8_t	fs_fsmnt[UFS_MAXMNTLEN - 212];	/* 0xd4=212 */
};

struct ufs_super_block_second {
	uint8_t	fs_fsmnt[212];			/* 0x00 */
	uint32_t	fs_cgrotor;		/* 0xd4 */
	uint32_t	fs_csp[UFS_MAXCSBUFS];	/* 0xd8 */
	uint32_t	fs_maxcluster;		/* 0x154 */
	uint32_t	fs_cpc;			/* 0x158 */
	uint16_t	fs_opostbl[82];		/* 0x15c */
};	

struct ufs_super_block_third {
	uint16_t	fs_opostbl[46];		/* 0x2e */
	union {
		struct {
			int32_t	fs_sparecon[53];/* reserved for future constants */
			int32_t	fs_reclaim;
			int32_t	fs_sparecon2[1];
			int32_t	fs_state;	/* file system state time stamp */
			uint32_t	fs_qbmask[2];	/* ~usb_bmask */
			uint32_t	fs_qfmask[2];	/* ~usb_fmask */
		} fs_sun;
		struct {
			int32_t	fs_sparecon[53];/* reserved for future constants */
			int32_t	fs_reclaim;
			int32_t	fs_sparecon2[1];
			uint32_t	fs_npsect;	/* # sectors/track including spares */
			uint32_t	fs_qbmask[2];	/* ~usb_bmask */
			uint32_t	fs_qfmask[2];	/* ~usb_fmask */
		} fs_sunx86;
		struct {
			int32_t	fs_sparecon[50];/* reserved for future constants */
			int32_t	fs_contigsumsize;/* size of cluster summary array */
			int32_t	fs_maxsymlinklen;/* max length of an internal symlink */
			int32_t	fs_inodefmt;	/* format of on-disk inodes */
			uint32_t	fs_maxfilesize[2];	/* max representable file size */
			uint32_t	fs_qbmask[2];	/* ~usb_bmask */
			uint32_t	fs_qfmask[2];	/* ~usb_fmask */
			int32_t	fs_state;	/* file system state time stamp */
		} fs_44;
	} fs_u2;			/* 0x5c */
	int32_t	fs_postblformat;	/* 0x14c */
	int32_t	fs_nrpos;		/* 0x150 */
	int32_t	fs_postbloff;		/* 0x154 */
	int32_t	fs_rotbloff;		/* 0x158 */
	int32_t	fs_magic;		/* 0x15c */
	uint8_t	fs_space[1];		/* 0x160 */
};

int check_ufs(t_param_disk *disk_car,t_partition *partition,const int debug);
int recover_ufs(t_param_disk *disk_car, const unsigned char *ubh, t_partition *partition,const int debug, const int dump_ind);

