'\"
'\" Generated from thread.tmml
'\"
'\" BEGIN man.macros
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp
..
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.if t .ft C
..
.de CE
.fi
.if t .ft R
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" END man.macros
.TH "Tcl Threading" n "2.5" Tcl ""
.BS
.SH NAME
thread \- A Tcl extension implementing script level access to Tcl threading capabilities.
.SH SYNOPSIS
.nf


.PP

\&\fBpackage require Thread ?2.5?\fP

\&\fBthread::create\fP ?\fI-joinable\fR? ?\fI-preserved\fR? ?\fIscript\fR?
\&\fBthread::preserve\fP \fIid\fR
\&\fBthread::release\fP ?\fI-wait\fR? \fIid\fR
\&\fBthread::id\fP
\&\fBthread::errorproc\fP ?\fIprocname\fR?
\&\fBthread::unwind\fP
\&\fBthread::exit\fP
\&\fBthread::names\fP
\&\fBthread::exists\fP \fIid\fR
\&\fBthread::send\fP ?\fI-async\fR? \fIid\fR \fIscript\fR ?\fIvarname\fR?
\&\fBthread::wait\fP
\&\fBthread::eval\fP ?\fI-lock mutex\fR? \fIarg\fR ?\fIarg ...\fR?
\&\fBthread::join\fP \fIid\fR
\&\fBthread::configure\fP \fIid\fR ?\fIoption\fR? ?\fIvalue\fR\fI? ?\fR\fIoption value\fR\fI?...\fR
\&\fBthread::transfer\fP \fIid\fR \fIchannel\fR
\&\fBthread::detach\fP \fIchannel\fR
\&\fBthread::attach\fP \fIchannel\fR
\&\fBthread::cond\fP \fIoptions\fR
\&\fBthread::mutex\fP \fIoptions\fR

.fi
.BE
.SH DESCRIPTION
.PP
The \fBthread\fP extension creates threads that contain Tcl
interpreters, and it lets you send scripts to those threads for evaluation.
Additionaly, it provides script-level access to basic thread synchronization
primitives, like mutexes and condition variables.
.SH COMMANDS
.PP
This section describes commands for creating and destroying threads
and sending scripts to threads for evaluation.
.TP
\&\fB \fBthread::create\fP ?\fI-joinable\fB? ?\fI-preserved\fB? ?\fIscript\fB?
\&\fRThis command creates a thread that contains a Tcl interpreter.
The Tcl interpreter either evaluates the optional \fIscript\fR, if
specified, or it waits in the event loop for scripts that arrive via
the \fBthread::send\fP command. The result, if any, of the
optional \fIscript\fR is never returned to the caller.
.RS
.PP
The result of \fBthread::create\fP is the ID of the thread. This is
the small integer handle which indentifies the newly created thread for
all other package commands. The handle of the thread goes out of scope
automatically when thread is marked for exit (see the \fBthread::release\fP
command below).
If the optional \fIscript\fR argument contains the \fBthread::wait\fP
command the thread will enter into the event loop. If such command is not found
in the \fIscript\fR the thread will run the \fIscript\fR to the end and exit.
In that case, the handle may be safely ignored since it refers to a thread
which does not exists any more at the time when the command returns.
Using flag \fI-joinable\fR it is possible to create a joinable
thread, i.e. one upon whose exit can be waited upon by using
\&\fBthread::join\fP command. Note that only Tcl8.4+ core supports joinable
threads. Note also that failure to join a thread created with
\&\fB-joinable\fP flag results in resource and memory leaks.
.PP
Threads created by the \fBthread::create\fP cannot be destroyed forcefully.
Consequently, there is no corresponding destroy-type command. A thread may only
be "released" using the \fBthread::release\fP and if its internal reference
count drops to zero, the thread is marked for exit. This kicks the thread out
of the event loop servicing and the thread continues to execute commands passed
in the \fIscript\fR argument, following the \fBthread::wait\fP command.
If this was the last command in the script, as usualy the case, the thread will
exit.
It is possible to create a situation in which it may be impossible to
terminate the thread, for example by putting some endless loop after the
\&\fBthread::wait\fP or entering the event loop again by doing an vwait-type
of command. In such cases, the thread may never exit. This is considered to
be a bad practice and should be avoided if possible.


.CS

    # You should NEVER do ...
    set tid [thread::create {
        packkage require Http
        thread::wait
        vwait forever ; # -- this!
    }]

.CE
.PP
The thread created in the above example will never be able to exit.
After it has been released with the last matching \fBthread::release\fP call
the thread will jump out of the \fBthread::wait\fP and continue to execute
commands following. It will enter \fBvwait\fP command and wait endlessly for
events. There is no way one can terminate such thread, so you wouldn't want to do this!
.PP
Each newly created has its internal reference counter set to 0 (zero), i.e. it is
unreserved. This counter gets incremented by a call to \fBthread::preserve\fP
and decremented by a call to \fBthread::release\fP command. These two commands
implement simple but effective thread reservation system and offer predictable and
controllable thread termination capabilities. It is however possible to create
initialy preserved threads by using flag \fI-preserved\fR. Threads
created with this flag have the initial value of the reference counter of 1 (one).
.RE
.TP
\&\fB \fBthread::preserve\fP ?\fIid\fB?
\&\fRThis command increments the thread reference counter. Each call
to this command increments the reference counter by one (1). Command returns
the value of the reference counter after the increment.
If called with the optional thread \fIid\fR, the command preserves the given
thread. Otherwise the current thread is preserved.\fB\fR
With reference counting, one can implement controlled access to a shared Tcl
thread.  By incrementing the reference counter, the caller signalizes that
he/she wishes to use the thread for a longer period of time. By decrementing
the counter, caller signalizes that he/she has finished using the thread.
.TP
\&\fB \fBthread::release\fP ?\fI-wait\fB? ?\fIid\fB?
\&\fRThis command decrements the thread reference counter. Each call to this
command decrements the reference counter by one (1).
If called with the optional thread \fIid\fR, the command releases the given
thread. Otherwise, the current thread is released.
Command returns the value of the reference counter after the decrement. When the
reference counter reaches zero (0), the target thread is marked for termination.
You should not reference the thread after the \fBthread::release\fP command
returns zero or negative integer. The handle of the thread goes out of scope and
should not be used any more. Any following reference to the same thread handle
will result in Tcl error.\fB\fR
Optional flag \fI-wait\fR instructs the caller thread to wait for the target
thread to exit, if the effect of the command would result in termination of the
target thread, i.e. if the return result would be zero (0). Without the flag, the
caller thread does not wait for the target thread to exit. Care must be taken
when using the \fI-wait\fR, since this may block the caller thread indefinitely.
.TP
\&\fB\fBthread::id\fP
\&\fRThis command returns the ID of the current thread.
.TP
\&\fB\fBthread::errorproc\fP ?\fIprocname\fB?
\&\fRThis command sets a handler for errors that occur in scripts sent 
asynchronously, using the \fB-async\fP flag of the 
\&\fBthread::send\fP command, to other threads. If no handler is specified,
the current handler is returned. The empty string resets the handler to default 
(unspecified) value.
An uncaught error in a thread causes an error message to be sent
to the standard error channel. This default reporting scheme can be
changed by registering a procedure which is called to report the error.
The \fIproc\fR is called in the interpreter that invoked the 
\&\fBthread::errorproc\fP command. The \fIproc\fR is called like this:

.RS
.CS
myerrorproc thread_id errorInfo
.CE
.RE
.TP
\&\fB\fBthread::unwind\fP
\&\fR
Use of this command is deprecated in favour of more advanced thread reservation
system implemented with \fBthread::preserve\fP and \fBthread::release\fP
commands. Support for \fBthread::wait\fP will dissapear in some future
major release of the extension.
\&\fB\fR
This stops a prior \fBthread::wait\fP. Execution of the script will
continue from the \fBthread::wait\fP command. If \fBthread::wait\fP
was the last command in the script passed to the thread at the time of its
creation, the thread will exit. The command usually returns empty result but
may trigger Tcl error with the message "target thread died" in some situations.
.TP
\&\fB\fBthread::exit\fP
\&\fR
Use of this command is deprecated in favour of the more advanced thread reservation
system implemented with \fBthread::preserve\fP and \fBthread::release\fP
commands. Use on your own risk and with extreme precaution. Support for
\&\fBthread::exit\fP will dissapear in  some future major release of the extension.
\&\fB\fR
This forces a thread stuck in the \fBthread::wait\fP to unconditionaly
exit. This command is guaranteed to leave the program memory in the unconsistent
state, produce memory leaks and otherwise affect other subsytem(s) of the Tcl
application in an unpredictable manner. The command usually  returns empty result.
but may trigger Tcl error with the message "target thread died" in some situations.
.TP
\&\fB\fBthread::names\fP
\&\fRThis command returns a list of thread IDs. These are only for
threads that have been created via \fBthread::create\fP. If your
application creates other threads at the C level, they are not
reported by the \fBthread::names\fP command.
.TP
\&\fB\fBthread::exists\fP \fIid\fB
\&\fRReturns true (1) if thread given by the ID parameter exists, false (0)
otherwise. This applies only for threads that have been created via
\&\fBthread::create\fP command.
.TP
\&\fB\fBthread::send\fP ?\fI-async\fB? \fIid\fB \fIscript\fB ?\fIvarname\fB?
\&\fRThis command passes a \fIscript\fR to another thread and, optionally, waits
for the result. If the \fB-async\fP flag is specified, the command does
not wait for the result and it returns empty string. The target thread must
enter it's event loop in order to receive scripts sent via this command.
This is done by default for threads created without a startup script. Threads
can enter the event loop explicitly by calling \fBthread::wait\fP or any other
relevant Tcl/Tk command, like \fBupdate\fP, \fBvwait\fP, etc.
.RS
.PP
Optional \fIvarname\fR specifies name of the variable to store
the result of the \fIscript\fR. Without the \fB-async\fP flag, the
command returns the evaluation code, similarily to the standard Tcl \fBcatch\fP
command. If, however, the \fB-async\fP flag is specified, the command
returns  immediately and caller can later \fBvwait\fP on \fIvarname\fR to
get the result of the passed \fIscript\fR.


.CS

    set t1 [thread::create]
    set t2 [thread::create] 
    thread::send -async $t1 "set a 1" result
    thread::send -async $t2 "set b 2" result 
    for {set i 0} {$i < 2} {incr i} {
        vwait result
    }

.CE
.PP
In the above example, two threads were fed work and both of them were instructed
to signalize the same variable "result" in the calling thread. The caller entered
the event loop twice to get both results. Note, however, that the order of the
received results may vary, depending on the current system load, type of work done,
etc, etc.
.PP
Many threads can simultaneously send scripts to the target thread for execution.
All of them are entered into the event queue of the target thread and
executed on the FIFO basis, intermingled with optional other events pending in
the event queue of the target thread.
.RE
.TP
\&\fB\fBthread::wait\fP
\&\fRThis enters the event loop so a thread can receive messages from 
\&\fBthread::send\fP. This command should only be used within 
the script passed to the \fBthread::create\fP. It should be the very last 
command in the script. If this is not the case, the exiting thread will continue
executing the script lines pass the \fBthread::wait\fP which is not what 
you usualy want and/or expect.

.RS
.CS

    set t1 [thread::create {
        #
        # Do some initialization work
        #
        thread::wait ; # Enter the event loop
    }

.CE
.RE
.TP
\&\fB\fBthread::eval\fP ?\fI-lock mutex\fB? \fIarg\fB ?\fIarg ...\fB?
\&\fRThis command concatenates passed arguments and evaluates the
resulting script under the mutex protection. If no mutex is specified,
using the \fI-lock mutex\fR optional argument, an internal
static mutex is used.
.TP
\&\fB\fBthread::join\fP \fIid\fB
\&\fRThis command waits for the thread with ID \fIid\fR to exit and
then returns it's exit code. Errors will be returned for threads which
are not joinable or already waited upon by another thread. Upon the join
the handle of the thread has gone out of scope and should not be used
any more.
.RS
.PP
NOTE: This command is available only when loaded into the Tcl8.4+ shell.
.RE
.TP
\&\fB\fBthread::configure\fP \fIid\fB ?\fIoption\fB? ?\fIvalue\fB\fI? ?\fB\fIoption value\fB\fI?...\fB
\&\fRThis command configures various low-level aspects of the thread with ID
\&\fIid\fR in the similar way as the standard Tcl command \fBfconfigure\fP
configures some Tcl channel options.
.RS
.PP
Options currently supported are: \fB-eventmark\fP and \fB-unwindonerror\fP.
.PP
The \fB-eventmark\fP option, when set, limits the number of asynchronously
posted scripts to the thread event loop. The \fBthread::send -async\fR
command will block until the number of pending scripts in the event
loop does not drop below the value configured with \fB-eventmark\fP.
Default value for the \fB-eventmark\fP is 0 (zero) which effectively
disables the checking, i.e. allows for unlimited number of posted scripts.
.PP
The boolean \fB-unwindonerror\fP option, when set, causes the target thread
to unwind if the result of the script processing resulted in error.
Default value for the \fB-unwindonerror\fP is 0 (false), i.e. thread continues
to process scripts after one of the posted scripts fails.
.RE
.TP
\&\fB\fBthread::transfer\fP \fIid\fB \fIchannel\fB
\&\fRThis moves the specified \fIchannel\fR from the
current thread and interpreter to the main interpreter of the thread
with the given \fIid\fR. After the move the current interpreter has no
access to the channel anymore, but the main interpreter of the target
thread will be able to use it from now on.
The command waits until the other thread has incorporated the
channel. Because of this it is possible to deadlock the participating
threads by commanding the other through a synchronous
\&\fBthread::send\fP to transfer a channel to us. This easily extends
into longer loops of threads waiting for each other.
Other restrictions: the channel in question must not be shared among
multiple interpreters running in the sending thread. This
automatically excludes the special channels for standard input, output
and error.
.RS
.PP

Due to the internal Tcl core implementation and the restriction on 
transferring shared channels, one has to take extra measures when
transferring socket channels created by accepting the connection
out of the \fBsocket\fP commands callback procedures:

.CS

    socket -server _Accept 2200
    proc _Accept {s ipaddr port} {
        after idle [list Accept $s $ipaddr $port]
    }
    proc Accept {s ipaddr port} {
        set tid [thread::create]
        thread::transfer $tid $s
    }

.CE
.PP
NOTE: this command is available only when loaded into the Tcl8.4+ shell.
.RE
.TP
\&\fB\fBthread::detach\fP \fIchannel\fB
\&\fRThis detaches the specified \fIchannel\fR from the
current thread and interpreter. After that, the current interpreter
has no access to the channel anymore. The channel is in the parked
state until some other (or the same) thread attaches the channel
again with \fBthread::attach\fP.
Restrictions: same as for transferring shared channels with the
\&\fBthread::transfer\fP command.
.RS
.PP
NOTE: this command is available only when loaded into the Tcl8.4+ shell.
.RE
.TP
\&\fB\fBthread::attach\fP \fIchannel\fB
\&\fRThis attaches the previously detached \fIchannel\fR in the
current thread/interpreter. For already existing channels,
the command does nothing, i.e. it is not an error to attach the
same channel more than once. The first operation will actualy
perform the operation, while all subsequent operation will just
do nothing.
Command throws error if the \fIchannel\fR cannot be found in the
list of detached channels and/or in the current interpreter.
.RS
.PP
NOTE: this command is available only when loaded into the Tcl8.4+ shell.
.RE
.TP
\&\fB \fBthread::mutex\fP \fIoptions\fB
\&\fRThis command provides script-level access to mutexes. Mutexes are most
common thread synchronization primitives. They are used to synchronize
access from two or more threads to one or more shared resources. Care has to
be taken when using mutexes in an multithreading program. Improper use of
mutexes may lead to various deadlock situations.
.RS
.PP
The \fBthread::mutex\fP command supports following subcommands and options:
.TP
\&\fB\fBthread::mutex create\fP
\&\fRCreates the mutex and returns it's opaque handle. This handle
should be used for any future reference to the newly created mutex.
.TP
\&\fB\fBthread::mutex destroy\fP \fImutex\fB
\&\fRDestroys the mutex \fImutex\fR. Extreme care has to be taken that
nobody is using the \fImutex\fR, otherwise unexpected errors may happen.
.TP
\&\fB\fBthread::mutex lock\fP \fImutex\fB
\&\fRLocks the mutex \fImutex\fR. Locking the mutex may deadlock the program
if same thread attempts to lock the same mutex twice without unlocking it
in between.
.TP
\&\fB\fBthread::mutex unlock\fP \fImutex\fB
\&\fRUnlocks the mutex \fImutex\fR so some other thread may lock it again.
.RE
.TP
\&\fB \fBthread::cond\fP \fIoptions\fB
\&\fRThis command provides script-level access to condition variables. A condition
variable creates a safe environment for the program to test some condition, sleep
on it when false and be awakened when it might have become true. A condition variable
is always used in the conjuction with a mutex.
.RS
.PP
The \fBthread::cond\fP supports following subcommands and options:
.TP
\&\fB\fBthread::cond create\fP
\&\fRCreates the condition variable and returns it's opaque handle. This handle
should be used for any future reference to newly created condition variable.
.TP
\&\fB\fBthread::cond destroy\fP \fIcond\fB
\&\fRDestroys condition variable \fIcond\fR. Extreme care has to be taken that nobody
is using (i.e. waiting on) the condition variable, otherwise unexpected
errors may happen.
.TP
\&\fB\fBthread::cond notify\fP \fIcond\fB
\&\fRWakes up all threads waiting on the condition variable \fIcond\fR.
.TP
\&\fB\fBthread::cond wait\fP \fIcond\fB \fImutex ?\fB\fIms?\fB
\&\fRThis command is used to suspend program execution until the condition
variable \fIcond\fR has been signalled (see \fBthread::cond notify\fR) or the
optional timer has expired. The \fImutex\fR must be locked by the calling
thread on entrance to \fBthread::cond wait\fR. While waiting on the \fIcond\fR,
the command releases \fImutex\fR. Before returning to the calling
thread, the command re-acquires \fImutex\fR again. Unlocking the \fImutex\fR
and waiting on the condition variable \fIcond\fR is done atomically.
.RS
.PP
The \fIms\fR command option, if given,  must be an integer specifying time
interval in milliseconds the command waits to be signalled. Otherwise
the command waits forever.
.PP
In multithreading programs, there are many situations where a thread has
to wait for some event to happen until it is allowed to proceed.
This is usually accomplished by repeatedly testing a condition under the
mutex protection and waiting on the condition variable until the condition
evaluates to true:


.CS

set mutex [thread::mutex create]
set cond  [thread::cond  create]

thread::mutex lock
while {<some_condition_is_true>} {
   thread::cond wait $cond $mutex
}
thread::mutex unlock
.CE
.PP
Repeated testing of the condition is needed since the condition variable
may get signalled without the condition being actually changed (spurious
thread wake-ups, for example).
.RE
.RE
.SH DISCUSSION
.PP
The fundamental threading model in Tcl is that there can be one or
more Tcl interpreters per thread, but each Tcl interpreter should only
be used by a single thread which created it.
A "shared memory" abstraction is awkward to provide in Tcl because Tcl
makes assumptions about variable and data ownership. Therefore this extension
supports a simple form of threading where the main thread can manage several
background, or "worker" threads. For example, an event-driven server can pass
requests to worker threads, and then await responses from worker threads or
new client requests. Everything goes through the common Tcl event loop, so
message passing between threads works naturally with event-driven I/O,
\&\fBvwait\fP on variables, and so forth. For the transfer of bulk information
it is possible to move channels between the threads.
.PP
For advanced multithreading scripts, script-level access to two basic
synchronization primitives, mutex and condition variables, is also supported.
.SH "SEE ALSO"
Guide to the Tcl threading model
.SH KEYWORDS
threads, events, message passing, synchronization, mutex, condition variable
