#!/bin/sh
#
#	tardy - a tar post-processor
#	Copyright (C) 2004 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the tardy -remprefix functionality
#

umask 022

USER=${USER:-${LOGNAME:-`whoami`}}

work=/tmp/$$
PAGER=cat
export PAGER

here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	find $work -type d -user $USER -exec chmod u+w {} \;
	rm -rf $work
	exit 0
}
fail()
{
	set +x
	echo 'FAILED test of the tardy -remprefix functionality' 1>&2
	cd $here
	find $work -type d -user $USER -exec chmod u+w {} \;
	rm -rf $work
	exit 1
}
no_result()
{
	set +x
	echo 'NO RESULT for test of the tardy -remprefix functionality' 1>&2
	cd $here
	find $work -type d -user $USER -exec chmod u+w {} \;
	rm -rf $work
	exit 2
}
trap \"no_result\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then no_result; fi
cd $work
if test $? -ne 0 ; then no_result; fi

#
# awk script to elide all but the name
#       (mode uid/gid size name)
#
cat > five.awk << 'fubar'
{ print $4 }
fubar
if test $? -ne 0 ; then no_result; fi

cat > test.ok << 'fubar'
cc/
cc/three
one
two
fubar
if test $? -ne 0 ; then no_result; fi

#
# test the tardy -remprefix functionality
#
mkdir -p aa/bb/cc
if test $? -ne 0 ; then no_result; fi
echo one > aa/one
if test $? -ne 0 ; then no_result; fi
echo two > aa/bb/two
if test $? -ne 0 ; then no_result; fi
echo three > aa/bb/cc/three
if test $? -ne 0 ; then no_result; fi

tar cf prefix.tar aa 
if test $? -ne 0 ; then no_result; fi

$bin/tardy -rp 2 prefix.tar noprefix.tar
if test $? -ne 0 ; then fail; fi

tar tf noprefix.tar > test.out.unsorted
if test $? -ne 0 ; then no_result; fi

sort test.out.unsorted > test.out
if test $? -ne 0 ; then no_result; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
