//
//	tardy - a tar post-processor
//	Copyright (C) 1998, 1999, 2002-2004 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: functions to manipulate tar outputs
//

#include <ac/errno.h>
#include <ac/stdio.h>
#include <ac/string.h>

#include <error.h>
#include <tar/output.h>


tar_output::tar_output()
{
}


tar_output::~tar_output()
{
}


void
tar_output::fatal(char *fmt, ...)
    const
{
    va_list ap;
    va_start(ap, fmt);
    char buffer[2000];
    vsnprintf(buffer, sizeof(buffer), fmt, ap);
    va_end(ap);
    const char *fn = filename();
    ::fatal("%s: %s", fn, buffer);
}


void
tar_output::nfatal(char *fmt, ...)
    const
{
    int err = errno;
    va_list ap;
    va_start(ap, fmt);
    char buffer[2000];
    vsnprintf(buffer, sizeof(buffer), fmt, ap);
    va_end(ap);
    const char *fn = filename();
    ::fatal("%s: %s: %s", fn, buffer, strerror(err));
}


void
tar_output::write_data_padding()
{
    // none by default
}


void
tar_output::write_header_padding()
{
    // same alignment as data by default
    write_data_padding();
}


void
tar_output::write_archive_begin()
{
    // none by default
}


void
tar_output::write_archive_end()
{
    // none by default
}


void
tar_output::set_block_size(long)
{
    // ignore by default
}
