/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ConfigurationPreferences
extends EclipsePreferences {
    private int segmentCount;
    private String qualifier;
    private IPath location;
    private IEclipsePreferences loadLevel;
    private static Set loadedNodes = new HashSet();

    public ConfigurationPreferences() {
        this(null, null);
    }

    private ConfigurationPreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
        this.initialize();
    }

    protected IPath getLocation() {
        return this.location;
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    private void initialize() {
        Path path = new Path(this.absolutePath());
        this.segmentCount = path.segmentCount();
        if (this.segmentCount < 2) {
            return;
        }
        String scope = path.segment(0);
        if ("configuration".equals(scope)) {
            this.qualifier = path.segment(1);
        }
        if (this.qualifier == null) {
            return;
        }
        URL url = InternalPlatform.getDefault().getConfigurationLocation().getURL();
        if (url != null) {
            this.location = this.computeLocation(new Path(url.getFile()), this.qualifier);
        }
    }

    public void sync() throws BackingStoreException {
        if (this.location == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Unable to determine location of preference file for node: " + this.absolutePath());
            }
            return;
        }
        IEclipsePreferences node = this.getLoadLevel();
        if (node == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Preference node is not a load root: " + this.absolutePath());
            }
            return;
        }
        if (node instanceof EclipsePreferences) {
            ((EclipsePreferences)node).load(this.location);
            node.flush();
        }
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName) {
        return new ConfigurationPreferences(nodeParent, nodeName);
    }
}

