/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PreferenceErrorDialog;
import org.eclipse.ui.internal.dialogs.PreferenceImportExportFileSelectionPage;
import org.eclipse.ui.internal.dialogs.PreferenceImportExportSettingsSelectionPage;

public class PreferenceImportExportWizard
extends Wizard {
    private final boolean export;
    private PreferenceImportExportFileSelectionPage fileSelectionPage;
    private final PreferenceDialog parent;
    private PreferenceImportExportSettingsSelectionPage settingsSelectionPage;

    public PreferenceImportExportWizard(boolean exportWizard, PreferenceDialog parentDialog) {
        this.export = exportWizard;
        this.parent = parentDialog;
        if (exportWizard) {
            this.setWindowTitle(WorkbenchMessages.getString("ImportExportPages.exportWindowTitle"));
        } else {
            this.setWindowTitle(WorkbenchMessages.getString("ImportExportPages.importWindowTitle"));
        }
    }

    public void addPages() {
        super.addPages();
        this.fileSelectionPage = new PreferenceImportExportFileSelectionPage(this.export);
        this.addPage((IWizardPage)this.fileSelectionPage);
        this.settingsSelectionPage = new PreferenceImportExportSettingsSelectionPage(this.export);
        this.addPage((IWizardPage)this.settingsSelectionPage);
    }

    public boolean canFinish() {
        if (this.fileSelectionPage.wantsPreferencesSelected()) {
            if (this.getContainer().getCurrentPage() == this.fileSelectionPage) {
                return false;
            }
            return this.fileSelectionPage.validate() && this.settingsSelectionPage.canFinish();
        }
        return this.fileSelectionPage.canFinish();
    }

    public boolean performFinish() {
        int result;
        Iterator nodes = this.parent.getPreferenceManager().getElements(0).iterator();
        while (nodes.hasNext()) {
            IPreferenceNode node = (IPreferenceNode)nodes.next();
            IPreferencePage page = node.getPage();
            if (page == null || page.performOk()) continue;
            return false;
        }
        String selectedFilePath = this.fileSelectionPage.getPath();
        File selectedFile = new File(selectedFilePath);
        long lastModified = selectedFile.lastModified();
        Path path = new Path(selectedFilePath);
        if (this.export) {
            if (selectedFile.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.existsErrorMessage", new Object[]{selectedFilePath}))) {
                return false;
            }
            try {
                Preferences.exportPreferences((IPath)path);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.saveErrorMessage", new Object[]{selectedFilePath}), (IStatus)e.getStatus());
                return false;
            }
        }
        IStatus status = Preferences.validatePreferenceVersions((IPath)path);
        if (status.getSeverity() == 4) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyErrorMessage", new Object[]{selectedFilePath}), (IStatus)status);
            return false;
        }
        if (status.getSeverity() == 2 && (result = PreferenceErrorDialog.openError(this.getShell(), WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyWarningMessage", new Object[]{selectedFilePath}), status)) != 0) {
            return false;
        }
        try {
            Preferences.importPreferences((IPath)path);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.loadErrorMessage", new Object[]{selectedFilePath}), (IStatus)e.getStatus());
            return false;
        }
        if (!this.export) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.loadMessage", new Object[]{selectedFilePath}));
        } else if (selectedFile.exists() && selectedFile.lastModified() != lastModified) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.saveMessage", new Object[]{selectedFilePath}));
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveErrorTitle"), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.noPreferencesMessage"));
        }
        WorkbenchPlugin.getDefault().getDialogSettings().put("PreferenceImportExportFileSelectionPage.filePath", this.fileSelectionPage.getPath());
        return true;
    }
}

