/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.undo;

import java.util.Iterator;
import swingwtx.swing.event.UndoableEditEvent;
import swingwtx.swing.event.UndoableEditListener;
import swingwtx.swing.undo.CannotRedoException;
import swingwtx.swing.undo.CannotUndoException;
import swingwtx.swing.undo.CompoundEdit;
import swingwtx.swing.undo.UndoableEdit;

public class UndoManager
extends CompoundEdit
implements UndoableEditListener {
    int limit = 100;
    int indexOfNextAdd = 0;

    public synchronized void setLimit(int limit) {
        this.limit = limit;
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized void discardAllEdits() {
        Iterator iterator = this.edits.iterator();
        while (iterator.hasNext()) {
            UndoableEdit undoableEdit = (UndoableEdit)iterator.next();
            undoableEdit.die();
        }
        this.edits.clear();
    }

    protected void undoTo(UndoableEdit undoableEdit) throws CannotUndoException {
        UndoableEdit curUndoableEdit;
        do {
            --this.indexOfNextAdd;
            if (this.indexOfNextAdd < 0) {
                this.indexOfNextAdd = 0;
                throw new CannotUndoException();
            }
            curUndoableEdit = (UndoableEdit)this.edits.get(this.indexOfNextAdd);
            curUndoableEdit.undo();
        } while (curUndoableEdit != undoableEdit);
    }

    public synchronized void undo() throws CannotUndoException {
        if (this.isInProgress()) {
            UndoableEdit edit = this.editToBeUndone();
            if (edit == null) {
                throw new CannotUndoException();
            }
            this.undoTo(edit);
        } else {
            super.undo();
        }
    }

    protected void redoTo(UndoableEdit undoableEdit) throws CannotRedoException {
        block1: {
            int size = this.edits.size();
            do {
                UndoableEdit curUndoableEdit = (UndoableEdit)this.edits.get(this.indexOfNextAdd);
                curUndoableEdit.redo();
                ++this.indexOfNextAdd;
                if (curUndoableEdit == undoableEdit) break block1;
            } while (this.indexOfNextAdd < size);
            this.indexOfNextAdd = 0;
            throw new CannotRedoException();
        }
    }

    public synchronized void redo() throws CannotRedoException {
        if (this.isInProgress()) {
            UndoableEdit edit = this.editToBeRedone();
            if (edit == null) {
                throw new CannotRedoException();
            }
            this.redoTo(edit);
        } else {
            super.redo();
        }
    }

    protected void trimEdits(int from, int to) {
        if (from <= to) {
            for (int itemsToRemove = to - from + 1; itemsToRemove > 0; --itemsToRemove) {
                ((UndoableEdit)this.edits.get(from)).die();
                this.edits.remove(from);
            }
            if (this.indexOfNextAdd > to) {
                this.indexOfNextAdd = this.indexOfNextAdd - to + from - 1;
            } else if (this.indexOfNextAdd >= from) {
                this.indexOfNextAdd = from;
            }
        }
    }

    protected void trimForLimit() {
        int size = this.edits.size();
        if (this.limit > 0 && size > this.limit) {
            int middle = this.limit / 2;
            int high = Math.min(this.indexOfNextAdd + middle - 1, size - 1);
            this.trimEdits(high + 1, size - 1);
            this.trimEdits(0, high - this.limit);
        }
    }

    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        if (this.indexOfNextAdd == this.edits.size()) {
            this.undo();
        } else {
            this.redo();
        }
    }

    public synchronized boolean canUndoOrRedo() {
        return false;
    }

    public synchronized boolean canUndo() {
        boolean canUndo = false;
        if (this.isInProgress()) {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit != null) {
                canUndo = undoableEdit.canUndo();
            }
        } else {
            canUndo = super.canUndo();
        }
        return canUndo;
    }

    public synchronized boolean canRedo() {
        boolean canRedo = false;
        if (this.isInProgress()) {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit != null) {
                canRedo = undoableEdit.canRedo();
            }
        } else {
            canRedo = super.canRedo();
        }
        return canRedo;
    }

    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        boolean success = super.addEdit(undoableEdit);
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return success;
    }

    public synchronized void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    public synchronized String getUndoPresentationName() {
        UndoableEdit undoableEdit;
        String presentationName = this.isInProgress() ? ((undoableEdit = this.editToBeUndone()) != null ? undoableEdit.getUndoPresentationName() : "Undo") : super.getUndoPresentationName();
        return presentationName;
    }

    public synchronized String getRedoPresentationName() {
        UndoableEdit undoableEdit;
        String presentationName = this.isInProgress() ? ((undoableEdit = this.editToBeUndone()) != null ? undoableEdit.getRedoPresentationName() : "Redo") : super.getRedoPresentationName();
        return presentationName;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.addEdit(undoableEditEvent.getEdit());
    }

    protected UndoableEdit editToBeUndone() {
        UndoableEdit undoableEdit = null;
        for (int i = this.indexOfNextAdd - 1; i >= 0; --i) {
            UndoableEdit curUndoableEdit = (UndoableEdit)this.edits.get(i);
            if (!curUndoableEdit.isSignificant()) continue;
            undoableEdit = curUndoableEdit;
            break;
        }
        return undoableEdit;
    }

    protected UndoableEdit editToBeRedone() {
        UndoableEdit undoableEdit = null;
        for (int i = this.indexOfNextAdd; i < this.edits.size(); ++i) {
            UndoableEdit curUndoableEdit = (UndoableEdit)this.edits.get(i);
            if (!curUndoableEdit.isSignificant()) continue;
            undoableEdit = curUndoableEdit;
            break;
        }
        return undoableEdit;
    }
}

