/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.event;

import java.util.EventObject;
import swingwtx.swing.tree.TreePath;

public class TreeSelectionEvent
extends EventObject {
    protected TreePath[] paths;
    protected boolean[] areNew;
    protected TreePath oldLeadSelectionPath;
    protected TreePath newLeadSelectionPath;

    public TreeSelectionEvent(Object source, TreePath[] paths, boolean[] areNew, TreePath oldLeadSelectionPath, TreePath newLeadSelectionPath) {
        super(source);
        this.paths = paths;
        this.areNew = areNew;
        this.oldLeadSelectionPath = oldLeadSelectionPath;
        this.newLeadSelectionPath = newLeadSelectionPath;
    }

    public TreeSelectionEvent(Object source, TreePath path, boolean isNew, TreePath oldLeadSelectionPath, TreePath newLeadSelectionPath) {
        super(source);
        this.paths = new TreePath[1];
        this.paths[0] = path;
        this.areNew = new boolean[1];
        this.areNew[0] = isNew;
        this.oldLeadSelectionPath = oldLeadSelectionPath;
        this.newLeadSelectionPath = newLeadSelectionPath;
    }

    public TreePath[] getPaths() {
        int numPaths = this.paths.length;
        TreePath[] retPaths = new TreePath[numPaths];
        System.arraycopy(this.paths, 0, retPaths, 0, numPaths);
        return retPaths;
    }

    public TreePath getPath() {
        return this.paths[0];
    }

    public boolean isAddedPath() {
        return this.areNew[0];
    }

    public boolean isAddedPath(TreePath path) {
        for (int counter = this.paths.length - 1; counter >= 0; --counter) {
            if (!this.paths[counter].equals(path)) continue;
            return this.areNew[counter];
        }
        throw new IllegalArgumentException("Invalid path");
    }

    public boolean isAddedPath(int index) {
        if (this.paths == null || index < 0 || index >= this.paths.length) {
            throw new IllegalArgumentException("Index too high");
        }
        return this.areNew[index];
    }

    public TreePath getOldLeadSelectionPath() {
        return this.oldLeadSelectionPath;
    }

    public TreePath getNewLeadSelectionPath() {
        return this.newLeadSelectionPath;
    }
}

