/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.Frame;
import swingwt.awt.Toolkit;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JDialog;
import swingwtx.swing.JLabel;
import swingwtx.swing.JList;
import swingwtx.swing.JOptionPane;
import swingwtx.swing.JPanel;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.JTextArea;

class SwingStyleInputDialog
extends JDialog {
    private boolean isTextEntry = false;
    private JTextArea text = null;
    private JList sel = null;

    public SwingStyleInputDialog(Component parent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        super((Frame)null, title, true);
        this.isTextEntry = selectionValues == null;
        this.setTitle(title);
        JLabel mess = new JLabel(message.toString());
        this.getContentPane().add((Component)mess, "North");
        JPanel pnlButtons = new JPanel();
        this.getContentPane().add((Component)pnlButtons, "South");
        JButton btnOk = new JButton("Ok");
        btnOk.setMnemonic('O');
        btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingStyleInputDialog.this.btnOk_clicked();
            }
        });
        pnlButtons.add(btnOk);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setMnemonic('C');
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingStyleInputDialog.this.btnCancel_clicked();
            }
        });
        pnlButtons.add(btnCancel);
        if (this.isTextEntry) {
            JScrollPane scr = new JScrollPane();
            this.text = new JTextArea();
            this.text.setWrapStyleWord(true);
            this.text.setLineWrap(true);
            if (initialSelectionValue != null) {
                this.text.setText(initialSelectionValue.toString());
            }
            scr.setViewportView(this.text);
            scr.setHorizontalScrollBarPolicy(5);
            scr.setVerticalScrollBarPolicy(1);
            this.getContentPane().add((Component)scr, "Center");
            this.setSize(400, 150);
        } else {
            this.sel = new JList(selectionValues);
            try {
                this.sel.setSelectedValue(initialSelectionValue, true);
            }
            catch (NullPointerException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            this.getContentPane().add((Component)this.sel, "Center");
            this.setSize(400, 300);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    protected void btnOk_clicked() {
        if (this.isTextEntry) {
            JOptionPane.lastInputDialogReturnValue = this.text.getText();
        } else {
            JOptionPane.lastInputDialogReturnValue = this.sel.getSelectedValue();
            JOptionPane.lastInputDialogReturnIndex = this.sel.getSelectedIndex();
        }
        JOptionPane.setJobFinished(true);
        this.dispose();
    }

    protected void btnCancel_clicked() {
        JOptionPane.lastInputDialogReturnValue = null;
        JOptionPane.lastInputDialogReturnIndex = -1;
        JOptionPane.setJobFinished(true);
        this.dispose();
    }
}

