/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwtx.swing.JComponent;
import swingwtx.swing.JPanel;
import swingwtx.swing.LayerComperator;
import swingwtx.swing.LayerComponent;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JLayeredPane
extends JPanel {
    public static final Integer DEFAULT_LAYER = new Integer(0);
    public static final Integer PALETTE_LAYER = new Integer(100);
    public static final Integer MODAL_LAYER = new Integer(200);
    public static final Integer POPUP_LAYER = new Integer(300);
    public static final Integer DRAG_LAYER = new Integer(400);
    public static final Integer FRAME_CONTENT_LAYER = new Integer(-30000);
    public static final String LAYER_PROPERTY = "layeredContainerLayer";
    protected Hashtable layerTable = new Hashtable(20);
    protected JLayeredPane self = this;
    protected LayerComponent[] layerComponents;

    public JLayeredPane() {
        this.setLayout(null);
    }

    public Component add(String string, Component component) {
        Component result = super.add(string, component);
        this.reorderComponents();
        return result;
    }

    public Component add(Component component) {
        Component result = super.add(component);
        this.setLayer(component, DEFAULT_LAYER);
        return result;
    }

    public void add(Component component, Object constraints) {
        super.add(component, constraints);
        this.reorderComponents();
    }

    public void setSwingWTParent(Container cont) throws Exception {
        super.setSwingWTParent(cont);
        this.reorderComponents();
    }

    protected void reorderComponents() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(JLayeredPane.this.self.getSWTPeer())) {
                    int i;
                    Component[] components = JLayeredPane.this.getComponents();
                    if (JLayeredPane.this.layerComponents == null || JLayeredPane.this.layerComponents.length != components.length) {
                        LayerComponent[] oldComponents = JLayeredPane.this.layerComponents;
                        JLayeredPane.this.layerComponents = new LayerComponent[components.length];
                        if (oldComponents != null) {
                            int minLenght = JLayeredPane.this.layerComponents.length < oldComponents.length ? JLayeredPane.this.layerComponents.length : oldComponents.length;
                            System.arraycopy(oldComponents, 0, JLayeredPane.this.layerComponents, 0, minLenght);
                        }
                    }
                    for (i = 0; i < components.length; ++i) {
                        if (components[i] instanceof JComponent) {
                            JComponent jComp = (JComponent)components[i];
                            if (JLayeredPane.this.layerComponents[i] == null) {
                                JLayeredPane.this.layerComponents[i] = new LayerComponent(jComp, (Integer)jComp.getClientProperty(JLayeredPane.LAYER_PROPERTY));
                                continue;
                            }
                            JLayeredPane.this.layerComponents[i].component = jComp;
                            JLayeredPane.this.layerComponents[i].layerValue = (Integer)jComp.getClientProperty(JLayeredPane.LAYER_PROPERTY);
                            continue;
                        }
                        if (JLayeredPane.this.layerComponents[i] == null) {
                            JLayeredPane.this.layerComponents[i] = new LayerComponent(components[i], (Integer)JLayeredPane.this.layerTable.get(components[i]));
                            continue;
                        }
                        JLayeredPane.this.layerComponents[i].component = components[i];
                        JLayeredPane.this.layerComponents[i].layerValue = (Integer)JLayeredPane.this.layerTable.get(components[i]);
                    }
                    Arrays.sort(JLayeredPane.this.layerComponents, new LayerComperator());
                    for (i = 1; i < JLayeredPane.this.layerComponents.length; ++i) {
                        if (!SwingWTUtils.isSWTControlAvailable(JLayeredPane.this.layerComponents[i - 1].component.getSWTPeer()) || !SwingWTUtils.isSWTControlAvailable(JLayeredPane.this.layerComponents[i].component.getSWTPeer())) continue;
                        JLayeredPane.this.layerComponents[i - 1].component.getSWTPeer().moveBelow(JLayeredPane.this.layerComponents[i].component.getSWTPeer());
                    }
                }
            }
        });
    }

    public int getPosition(Component c) {
        return 0;
    }

    protected int insertIndexForLayer(int layer, int position) {
        return this.getComponentCount();
    }

    public void setLayer(Component c, int layer, int position) {
        JLayeredPane.putLayer((JComponent)c, layer);
        this.reorderComponents();
    }

    public Component[] getComponentsInLayer(int layer) {
        int componentCount = this.getComponentCount();
        LinkedList<Component> componentList = new LinkedList<Component>();
        for (int i = 0; i < componentCount; ++i) {
            Component comp = this.getComponent(i);
            if (comp instanceof JComponent) {
                JComponent jComp = (JComponent)comp;
                if ((Integer)jComp.getClientProperty(LAYER_PROPERTY) != layer) continue;
                componentList.add(comp);
                continue;
            }
            int actLayerVal = (Integer)this.layerTable.get(comp);
            if (actLayerVal != layer) continue;
            componentList.add(comp);
        }
        return componentList.toArray(new Component[0]);
    }

    int getComponentCountInLayer(int layer) {
        int componentCount = this.getComponentCount();
        int layerCount = 0;
        for (int i = 0; i < componentCount; ++i) {
            int actLayer = this.getLayer(this.getComponent(i));
            if (actLayer == layer) {
                ++layerCount;
                continue;
            }
            if (layerCount > 0 || actLayer < layer) break;
        }
        return layerCount;
    }

    protected Hashtable getComponentToLayer() {
        return this.layerTable;
    }

    public int getIndexOf(Component c) {
        return this.comps.indexOf(c);
    }

    public int getLayer(Component c) {
        if (c instanceof JComponent) {
            return JLayeredPane.getLayer((JComponent)c);
        }
        return (Integer)this.layerTable.get(c);
    }

    protected Integer getObjectForLayer(int layer) {
        Integer intObj;
        switch (layer) {
            case 0: {
                intObj = DEFAULT_LAYER;
                break;
            }
            case 100: {
                intObj = PALETTE_LAYER;
                break;
            }
            case 200: {
                intObj = MODAL_LAYER;
                break;
            }
            case 300: {
                intObj = POPUP_LAYER;
                break;
            }
            case 400: {
                intObj = DRAG_LAYER;
                break;
            }
            default: {
                intObj = new Integer(layer);
            }
        }
        return intObj;
    }

    public int lowestLayer() {
        int componentCount = this.getComponentCount();
        int lowestLayer = 0;
        if (componentCount > 0) {
            lowestLayer = Integer.MAX_VALUE;
            for (int i = 0; i < componentCount; ++i) {
                int actLayer = this.getLayer(this.getComponent(i));
                if (actLayer >= lowestLayer) continue;
                lowestLayer = actLayer;
            }
        }
        return lowestLayer;
    }

    public int highestLayer() {
        int componentCount = this.getComponentCount();
        int highestLayer = 0;
        if (componentCount > 0) {
            highestLayer = Integer.MIN_VALUE;
            for (int i = 0; i < componentCount; ++i) {
                int actLayer = this.getLayer(this.getComponent(i));
                if (actLayer <= highestLayer) continue;
                highestLayer = actLayer;
            }
        }
        return highestLayer;
    }

    public void moveToBack(Component c) {
        this.setPosition(c, 0);
    }

    void moveToFront(Component c) {
        this.setPosition(c, this.highestLayer() + 1);
    }

    protected String paramString() {
        return "false";
    }

    public void remove(int index) {
        Component comp = this.getComponent(index);
        if (comp != null && !(comp instanceof JComponent)) {
            this.layerTable.remove(comp);
        }
        super.remove(index);
    }

    public void setLayer(Component c, int layer) {
        this.setLayer(c, layer, -1);
    }

    public void setPosition(Component c, int position) {
        this.setLayer(c, this.getLayer(c), position);
    }

    static void putLayer(JComponent c, int layer) {
        Integer layerValue = new Integer(layer);
        c.putClientProperty(LAYER_PROPERTY, layerValue);
    }

    public static int getLayer(JComponent c) {
        Integer layer = (Integer)c.getClientProperty(LAYER_PROPERTY);
        if (layer != null) {
            return layer;
        }
        return DEFAULT_LAYER;
    }

    public static JLayeredPane getLayeredPaneAbove(Component c) {
        Container parentComponent;
        if (c == null) {
            return null;
        }
        for (parentComponent = c.getParent(); parentComponent != null && !(parentComponent instanceof JLayeredPane); parentComponent = ((Component)parentComponent).getParent()) {
        }
        return (JLayeredPane)parentComponent;
    }
}

