/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.HashMap;
import swingwtx.swing.KeyStroke;

public class InputMap {
    private HashMap hashMap = new HashMap();
    private InputMap parent = null;

    public void setParent(InputMap parent) {
        this.parent = parent;
    }

    public InputMap getParent() {
        return this.parent;
    }

    public Object get(KeyStroke keyStroke) {
        Object value = null;
        if (this.hashMap.containsKey(value)) {
            value = this.hashMap.get(keyStroke);
        } else if (this.parent != null) {
            value = this.parent.get(keyStroke);
        }
        return value;
    }

    public void put(KeyStroke keyStroke, Object inputMapKey) {
        if (inputMapKey != null) {
            if (inputMapKey == null) {
                this.remove(keyStroke);
            } else {
                this.hashMap.put(keyStroke, inputMapKey);
            }
        }
    }

    public void remove(KeyStroke key) {
        this.hashMap.remove(key);
    }

    public void clear() {
        this.hashMap.clear();
    }

    public KeyStroke[] keys() {
        return this.hashMap.keySet().toArray(new KeyStroke[0]);
    }

    public int size() {
        return this.hashMap.size();
    }

    HashMap getHashMap() {
        return this.hashMap;
    }

    HashMap allKeyValues() {
        HashMap keyValues = (HashMap)this.hashMap.clone();
        if (this.parent != null) {
            keyValues.putAll(this.parent.allKeyValues());
        }
        return keyValues;
    }

    public KeyStroke[] allKeys() {
        return this.allKeyValues().keySet().toArray(new KeyStroke[0]);
    }
}

