/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.ControlTabInfoRecV1;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;
    int cIcon;
    static final int EXTRA_WIDTH = 25;

    public TabItem(TabFolder parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
    }

    int calculateWidth(GC gc) {
        int width = 0;
        Image image = this.getImage();
        String text = this.getText();
        if (image != null) {
            width = image.getBounds().width + 2;
        }
        if (text != null && text.length() > 0) {
            width += gc.stringExtent((String)text).x;
        }
        return width + 25;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseChild() {
        super.releaseChild();
        int index = this.parent.indexOf(this);
        if (index == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        if (this.control != null) {
            this.control.setVisible(false);
        }
        super.releaseWidget();
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
            this.cIcon = 0;
        }
        this.control = null;
        this.parent = null;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != this.parent.getSelectionIndex()) {
            if (newControl != null) {
                newControl.setVisible(false);
            }
            return;
        }
        if (newControl != null) {
            newControl.setBounds(this.parent.getClientArea());
            newControl.setVisible(true);
        }
        if (oldControl != null) {
            oldControl.setVisible(false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        super.setImage(image);
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
            this.cIcon = 0;
        }
        ControlButtonContentInfo inContent = new ControlButtonContentInfo();
        if (image == null) {
            inContent.contentType = 0;
        } else {
            this.cIcon = this.createCIcon(image);
            inContent.contentType = (short)130;
            inContent.iconRef = this.cIcon;
        }
        OS.SetControlData((int)this.parent.handle, (int)(index + 1), (int)1668247156, (int)6, (ControlButtonContentInfo)inContent);
        this.parent.redraw();
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)length);
        if (ptr == 0) {
            this.error(13);
        }
        ControlTabInfoRecV1 tab = new ControlTabInfoRecV1();
        tab.version = 1;
        tab.iconSuiteID = 0;
        tab.name = ptr;
        OS.SetControlData((int)this.parent.handle, (int)(index + 1), (int)1952539241, (int)8, (ControlTabInfoRecV1)tab);
        OS.CFRelease((int)ptr);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

