/*==================================================================
 * ptrstrip.h - Header file for pointer strip widget
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 *==================================================================*/
#ifndef __PTRSTRIP_WIDG_H__
#define __PTRSTRIP_WIDG_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

#define PTRSTRIP(obj)	GTK_CHECK_CAST(obj, ptrstrip_get_type(), PtrStrip)
#define PTRSTRIP_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, ptrstrip_get_type(), PtrStripClass)
#define IS_PTRSTRIP(obj)	GTK_CHECK_TYPE(obj, ptrstrip_get_type())

typedef struct _PtrStrip PtrStrip;
typedef struct _PtrStripClass PtrStripClass;
typedef struct _PtrStripPointer PtrStripPointer;

struct _PtrStripPointer
{
  int xpos;			/* position of pointer */
};

struct _PtrStrip
{
  GtkWidget widget;

  GList *pointers;		/* linked list of pointers */
  GList *selpointer;		/* currently selected pointer or NULL */

  GdkPixmap *pointer_pm;	/* pointer pixmap */
  GdkBitmap *pointer_mask;	/* pointer bitmap transparency mask */
};

struct _PtrStripClass
{
  GtkWidgetClass parent_class;

  void (*pointer_change) (PtrStrip * ptrstrip, guint ptrndx);
  void (*pointer_select) (PtrStrip * ptrstrip, guint ptrndx);
  void (*pointer_unselect) (PtrStrip * ptrstrip, guint ptrndx);
};

guint ptrstrip_get_type (void);
GtkWidget *ptrstrip_new (void);
void ptrstrip_new_pointer (PtrStrip * ptrstrip, gint xpos);
void ptrstrip_set_pointer (PtrStrip * ptrstrip, guint ptrndx, gint xpos);

#endif
