/**
 * \file SwamiUITreeMenu.h
 * \brief Swami tree menu object header file
 *
 * Object that provides the right click sound font tree menus.
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_TREEMENU_H__
#define __SWAMIUI_TREEMENU_H__

#include <gtk/gtk.h>
#include "SwamiUITree.h"

#include "swamidll.h"

typedef struct _SwamiUITreeMenu SwamiUITreeMenu;
typedef struct _SwamiUITreeMenuClass SwamiUITreeMenuClass;

#define SWAMIUI_TYPE_TREEMENU   (swamiui_treemenu_get_type ())
#define SWAMIUI_TREEMENU(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_TREEMENU, SwamiUITreeMenu))
#define SWAMIUI_TREEMENU_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_TREEMENU, SwamiUITreeMenuClass))
#define SWAMIUI_IS_TREEMENU(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_TREEMENU))
#define SWAMIUI_IS_TREEMENU_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_TREEMENU))

/** Swami TreeMenu Object (all fields private) */
struct _SwamiUITreeMenu
{
  GtkMenu parent;		/* derived from GtkMenu */
  SwamiUITree *tree;		/* tree object menu is bound to */
  GArray *mitem_array;		/* array of menu items */
  GtkAccelGroup *accel_group;	/* key acceleration group for menu items */
};

/** Swami TreeMenu Object class (all fields private) */
struct _SwamiUITreeMenuClass
{
  GtkMenuClass parent_class;

  SwamiUITreeMenu *active_treemenu; /* active tree menu object (currently in
				         callback) or NULL */
};

/**
 * \brief Tree menu callback function type
 * \param items List of selected items in tree
 * \param data User defined data pointer
 */
typedef void (* SwamiUITreeMenuCallback)(GList *items, gpointer data);

/* function prototypes */

SWAMI_API guint swamiui_treemenu_get_type (void);
SWAMI_API GtkWidget *swamiui_treemenu_new (SwamiUITree *bind_tree);
SWAMI_API void swamiui_treemenu_popup (SwamiUITreeMenu *treemenu, guint button,
				       guint32 time);

#endif
