/*
 *  anthycontainer.h
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __ANTHY_CONTAINER_H__
#define __ANTHY_CONTAINER_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "anthyaddwordpane.h"
#include "anthyviewwordpane.h"
#include "anthyimportwordpane.h"

typedef struct anthycontainer {
	GtkWidget *container; /* GtkNoteBook */

	AnthyViewWordPane *viewwordpane;
	AnthyAddWordPane *addwordpane;
	AnthyImportWordPane *importwordpane;
} AnthyContainer;

void create_anthycontainer(AnthyContainer *container);
void show_anthycontainer(AnthyContainer *container, gboolean flags);
void clean_anthycontainer(AnthyContainer *container);
	
#endif /* __ANTHY_CONTAINER_H__ */
