/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_SPLASH_H
#define _ST_SPLASH_H

#include <gtk/gtk.h>

#define ST_TYPE_SPLASH			(st_splash_get_type())
#define ST_SPLASH(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_SPLASH, STSplash))
#define ST_SPLASH_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_SPLASH, STSplashClass))
#define ST_IS_SPLASH(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_SPLASH))
#define ST_IS_SPLASH_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_SPLASH))
#define ST_SPLASH_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_SPLASH, STSplashClass))

typedef struct _STSplashPrivate STSplashPrivate;

typedef struct
{
  GtkWindow		window;

  STSplashPrivate	*priv;
} STSplash;

typedef struct
{
  GtkWindowClass	parent_class;
} STSplashClass;

GType		st_splash_get_type	(void);
GtkWidget	*st_splash_new		(void);

void		st_splash_set_text	(STSplash	*splash,
					 const char	*str);
void		st_splash_set_progress	(STSplash	*splash,
					 double		progress);

#endif /* _ST_SPLASH_H */
