package SliMP3::Buttons::InstantMix;

# license bla

use strict;
use SliMP3::Buttons::Common;
use SliMP3::MoodLogic;
use SliMP3::Strings qw (string);
use SliMP3::Timers;
use SliMP3::VFD;

# button functions for browse directory
my @instantMix = ();

my %functions = (
	
	'up' => sub  {
		my $client = shift;
                my $count = scalar @instantMix;
                
		if ($count < 2) {
			SliMP3::Animation::bumpUp($client);
		} else {
                    my $newposition = SliMP3::Buttons::Common::scroll($client, -1, ($#instantMix + 1), selection($client, 'instant_mix_index'));
                    setSelection($client, 'instant_mix_index', $newposition);
                    SliMP3::Display::update($client);
		}
	},
	
	'down' => sub  {
		my $client = shift;
		my $count = scalar @instantMix;

		if ($count < 2) {
			SliMP3::Animation::bumpDown($client);
		} else {
                    my $newposition = SliMP3::Buttons::Common::scroll($client, +1, ($#instantMix + 1), selection($client, 'instant_mix_index'));
                    setSelection($client, 'instant_mix_index', $newposition);
                    SliMP3::Display::update($client);
		}
	},
	
	'left' => sub  {
		my $client = shift;
		SliMP3::Buttons::Common::popModeRight($client);
	},
	
	'right' => sub  {
                my $client = shift;
                
                my @oldlines = SliMP3::Display::curLines($client);
		SliMP3::Buttons::Common::pushMode($client, 'trackinfo', {'track' => $instantMix[selection($client, 'instant_mix_index')]});
		SliMP3::Animation::pushLeft($client, @oldlines, SliMP3::Display::curLines($client));
	},
	'play' => sub  {
		my $client = shift;
		my $button = shift;
		my $append = shift;
		my $line1;
		my $line2;
		
		if ($append) {
			$line1 = string('ADDING_TO_PLAYLIST')
		} elsif (SliMP3::Playlist::shuffle($client)) {
			$line1 = string('PLAYING_RANDOMLY_FROM');
		} else {
			$line1 = string('NOW_PLAYING_FROM')
		}
	 	$line2 = string('MOODLOGIC_INSTANT_MIX');

		SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')));
		
		SliMP3::Command::execute($client, ["playlist", $append ? "append" : "play", $instantMix[0]]);
		
		for (my $i=1; $i<=$#instantMix; $i++) {
                        SliMP3::Command::execute($client, ["playlist", "append", $instantMix[$i]]);		    
		}
	},
);

sub getFunctions {
	return \%functions;
}

sub setMode {
	my $client = shift;
	my $push = shift;

        if ($push eq "push") {
            setSelection($client, 'instant_mix_index', 0);
            
            if (defined SliMP3::Buttons::Common::param($client, 'song')) {
                @instantMix = SliMP3::MoodLogic::getMix(SliMP3::Info::moodLogicSongId(SliMP3::Buttons::Common::param($client, 'song')), undef, 'song');
            } elsif (defined SliMP3::Buttons::Common::param($client, 'artist') && defined SliMP3::Buttons::Common::param($client, 'mood')) {
                @instantMix = SliMP3::MoodLogic::getMix(SliMP3::Info::moodLogicArtistId(SliMP3::Buttons::Common::param($client, 'artist')), SliMP3::Buttons::Common::param($client, 'mood'), 'artist');
            } elsif (defined SliMP3::Buttons::Common::param($client, 'genre') && defined SliMP3::Buttons::Common::param($client, 'mood')) {
                @instantMix = SliMP3::MoodLogic::getMix(SliMP3::Info::moodLogicGenreId(SliMP3::Buttons::Common::param($client, 'genre')), SliMP3::Buttons::Common::param($client, 'mood'), 'genre');
            } else {
                die 'no/unknown type specified for instant mix';
            }
        } 
	
	$client->lines(\&lines);
}

#
# figure out the lines to be put up to display
#
sub lines {
	my $client = shift;
	my ($line1, $line2);

	$line1 = string('MOODLOGIC_INSTANT_MIX');
	$line1 .= sprintf(" (%d ".string('OUT_OF')." %s)", selection($client, 'instant_mix_index') + 1, scalar @instantMix);	
	$line2 = SliMP3::Info::infoFormat($instantMix[selection($client, 'instant_mix_index')], 'TITLE (ARTIST)', 'TITLE');

	return ($line1, $line2, undef, SliMP3::VFD::symbol('rightarrow'));
}

#	get the current selection parameter from the parameter stack
sub selection {
	my $client = shift;
	my $index = shift;

	my $value = SliMP3::Buttons::Common::param($client, $index);

	if (defined $value  && $value eq '__undefined') {
		undef $value;
	}

	return $value;
}

#	set the current selection parameter from the parameter stack
sub setSelection {
	my $client = shift;
	my $index = shift;
	my $value = shift;

	if (!defined $value) {
		$value = '__undefined';
	}

	SliMP3::Buttons::Common::param($client, $index, $value);
}

sub specialPushLeft {
        my $client = shift @_;
        my $step = shift @_;
        my @oldlines = @_;

	my $now = Time::HiRes::time();
	my $when = $now + 0.5;
	
        if ($step == 0) {
            SliMP3::Buttons::Common::pushMode($client, 'block');
            SliMP3::Animation::pushLeft($client, @oldlines, string('MOODLOGIC_MIXING'));
            SliMP3::Timers::setTimer($client,$when,\&specialPushLeft,$step+1);
        } elsif ($step == 3) {
            SliMP3::Buttons::Common::popMode($client);            
            SliMP3::Animation::pushLeft($client, string('MOODLOGIC_MIXING')."...", "", SliMP3::Display::curLines($client));
        } else {
            SliMP3::VFD::vfdUpdate($client, SliMP3::Display::renderOverlay(string('MOODLOGIC_MIXING').("." x $step), undef, undef, undef));
            SliMP3::Timers::setTimer($client,$when,\&specialPushLeft,$step+1);
        }
}


1;

__END__
