package SigC;

sub parse_version {return (shift =~ /^([0-9]*)\.([0-9]*)\.([0-9]*)$/);}

sub basic_configure {
  use Carp;

  my ($library_name, $minversion, $config_script,
    $version_flag, $cflags_flag, $libs_flag) = @_;

  $version_flag ||= $config_script ? '--version' : '--modversion';
  $cflags_flag ||= '--cflags';
  $libs_flag ||= '--libs';
  $config_script ||= 'pkg-config ' . $library_name;

  my $version = `$config_script $version_flag`;
  $version or croak <<EOT;
****************************************************************
* Required library $library_name not found!
****************************************************************
EOT
  chomp $version;

  if($minversion) {
    my ($major, $minor, $micro) = parse_version($version);
    my ($minmajor, $minminor, $minmicro) = parse_version($minversion);

    ($major > $minmajor or ($major == $minmajor and ($minor > $minminor
      or ($minor == $minminor and $micro >= $minmicro)))) 
        or croak <<EOT;
****************************************************************
* This module requires $library_name version $minversion.
* You only have version $version.
****************************************************************
EOT
  }

  my $ldflags = `$config_script $libs_flag`;
  my $cflags = `$config_script $cflags_flag`;
  chomp ($cflags, $ldflags);

  # Makefile.PL only likes -L and -l arguments, so clean up $ldflags

  my $libs;

  while($ldflags =~ /(-[lL]\S*)/g) {
    $libs .= $1 . " ";
  }

  return ($cflags, $libs);
}

sub pkg_configure {
  my $cflags, $libs;
  my %packages = @_;

  foreach (keys %packages) {
    my ($tmp_cflags, $tmp_libs) = basic_configure($_, $packages{$_});
    $cflags .= " $tmp_cflags";
    $libs .= " $tmp_libs";
  }

  return ($cflags, $libs);
}

sub configure {
  use Carp;
  my $error;

  @_ = ('0.2.0', '0.1.3') unless @_;

  foreach(@_) {
    my($major, $minor) = parse_version($_);
    my @args = ('sigcperl', $_);
    push @args, 'sigcperl-config' if $major == 0 and $minor < 2;
    my @vals;
    eval {@vals = basic_configure(@args);};
    return @vals unless $@;
    $error .= $@ unless $@ =~ /not found/;
  }

  croak $error if $error;

  croak <<EOT;
****************************************************************
* Required library sigcperl not found!
****************************************************************
EOT
}

# Test code

#my ($cflags, $libs) = configure();
#print"cflags = $cflags\nlibs = $libs\n";
