
///////////////////////////////////////////////////////////////////////////////
//
//    SAOL Resonator-Based Physical Model Library
//    This file: Macros for resonator library
//    Copyright (C) 2000  Regents of the University of California
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License (Version 2) as
//    published by the Free Software Foundation.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    Original Author: John Wawrzynek
//    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu
//
///////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////
//
// Vector sum over resonator output -- much faster than looping

#if (RESON_RESNUM == 0)
#define RESON_SUMOUT 0.0
#endif

#if (RESON_RESNUM == 1)
#define RESON_SUMOUT (sy[0])
#endif

#if (RESON_RESNUM == 2)
#define RESON_SUMOUT (sy[0]+sy[1])
#endif

#if (RESON_RESNUM == 3)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2])
#endif

#if (RESON_RESNUM == 4)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2]+sy[3])
#endif

#if (RESON_RESNUM == 5)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2]+sy[3]+sy[4])
#endif

#if (RESON_RESNUM == 6)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2]+sy[3]+sy[4]+sy[5])
#endif

#if (RESON_RESNUM == 7)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2]+sy[3]+sy[4]+sy[5]+sy[6])
#endif

#if (RESON_RESNUM == 8)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2]+sy[3]+sy[4]+sy[5]+sy[6]+sy[7])
#endif

#if (RESON_RESNUM == 9)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2]+sy[3]+sy[4]+sy[5]+sy[6]+sy[7]+sy[8])
#endif

#if (RESON_RESNUM == 10)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2]+sy[3]+sy[4]+sy[5]+sy[6]+sy[7]+sy[8]+sy[9])
#endif

#if (RESON_RESNUM == 11)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2]+sy[3]+sy[4]+sy[5]+sy[6]+sy[7]+sy[8]+sy[9] + sy[10])
#endif

#if (RESON_RESNUM == 12)
#define RESON_SUMOUT (sy[0]+sy[1]+sy[2]+sy[3]+sy[4]+sy[5]+sy[6]+sy[7]+sy[8]+sy[9] + sy[10] + sy[11])
#endif

#if (RESON_RESNUM > 12)
#define RESON_SUMOUT "extend reson/macro.hs"
#endif








