/*
 * robwxfe.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// The Frontend class for visualization mode

#ifndef __RT_ROBWXFE_H__
#define __RT_ROBWXFE_H__

#include <rtlist.h>

#include "robfrontend.h"
#include "robconsole.h"

namespace rt {

class BotErrorHandler {
public:
	/** This method is called when a robot is deleted due to a RoboCom fatal error. */
	virtual void handleBotError(const Bot* affectedBot, ExecReturnType type) = 0;
};

class WxFrontend : public ConsoleFrontend {
public:
	WxFrontend();
	~WxFrontend();

	virtual void handleBotError(const Bot* affectedBot, ExecReturnType type) const;
	virtual void handleLoadError(const String& affectedFile, const String& message) const;
	virtual void handleSystemError(int num, const String& message) const;
	virtual void handleWarning(const String& message) const;

	void addBotErrorHandler(BotErrorHandler* handler);
	void removeBotErrorHandler(BotErrorHandler* handler);

protected:
	virtual bool interpreteParamsImpl(const Array<String>& params, Array<bool>& used);

private:
	lrt::List<BotErrorHandler*> botErrorHandlers;
};


} // NAMESPACE

#endif //FILE
