#ifndef ROBODOC_FOLDS_H
#define ROBODOC_FOLDS_H



/****s* Folds/fold_mark_t
 * NAME
 *   fold_mark_t
 * FUNCTION
 *   Handy structure for fold start/end markers.
 * SOURCE
 */

typedef struct _fold_mark_t
{
    char               *start;
    char               *end;
} fold_mark_t;

/*******/

/****d* Folds/extra_flags
* NAME
*   extra_flags
* AUTHOR
*   PetteriK
* FUNCTION
*   Bitflags for extra controls.
* SOURCE
*/

#define FOLD     (1<<0)
#define C_MODE   (1<<1)


/****/

extern fold_mark_t  fold_start_markers[];
extern fold_mark_t  fold_end_markers[];
extern long         extra_flags;
extern int          fold;

char               *RB_Fold( char *line, char **doc_name, FILE ** dest_doc,
                             char *extension, char *charset );

char                RB_Inside_Fold( void );
void                RB_Enter_Fold( void );
void                RB_Exit_Fold( void );

#endif /* ROBODOC_FOLDS_H */
