# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Time", "Object", "class")
aClass.addFragment(Paragraph.new("<code>Time</code> is an abstraction of dates and times. Time is stored internally as the number of seconds and microseconds since the <em>epoch</em>, January 1, 1970 00:00 UTC. Also see the library modules <code>Date</code> and <code>ParseDate</code>, documented beginning on pages 443 and 457, respectively. The <code>Time</code> class treats GMT (Greenwich Mean Time) and UTC (Coordinated Universal Time)<em>[Yes, UTC really does stand for Coordinated Universal Time. There was a committee involved.]</em> as equivalent. GMT is the older way of referring to these baseline times but persists in the names of calls on Posix systems.\n"))
aClass.addFragment(Paragraph.new("All times are stored with some number of microseconds. Be aware of this fact when comparing times with each other---times that are apparently equal when displayed may be different when compared.\n"))
m0002 = MethodDesc.new("at", "class", "Time.at( <i>aTime</i> ) -> <i>aTime</i> <br></br>Time.at( <i>seconds</i> <i>[</i>, <i>microseconds</i><i>]</i> ) -> <i>aTime</i>")
m0002.addFragment(Paragraph.new("Creates a new time object with the value given by <i>aTime</i>, or the given number of <i>seconds</i> (and optional <i>microseconds</i>) from epoch.\n"))
m0002.addFragment(Verbatim.new("Time.at(0)           \#=> Wed Dec 31 18:00:00 CST 1969\nTime.at(946702800)   \#=> Fri Dec 31 23:00:00 CST 1999\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("gm", "class", "Time.gm( <i>year <i>[</i>, month, day, hour, min, sec, usec<i>]</i></i> ) -> <i>aTime</i> <br></br>Time.gm( <i>sec, min, hour, day, month, year, wday, yday, isdst, tz</i> ) -> <i>aTime</i>")
m0003.addFragment(Paragraph.new("Creates a time based on given values, interpreted as UTC (GMT). The year must be specified. Other values default to the minimum value for that field (and may be <code>nil</code> or omitted). Months may be specified by numbers from 1 to 12, or by the three-letter English month names. Hours are specified on a 24-hour clock (0..23). Raises an <code>ArgumentError</code> if any values are out of range. Will also accept ten arguments in the order output by <code>Time\#to_a</code>.\n"))
m0003.addFragment(Verbatim.new("Time.gm(2000,\"jan\",1,20,15,1)   \#=> Sat Jan 01 20:15:01 UTC 2000\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("local", "class", "Time.local( <i>year <i>[</i>, month, day, hour, min, sec, usec<i>]</i></i> ) -> <i>aTime</i> <br></br>Time.local( <i>sec, min, hour, day, month, year, wday, yday, isdst, tz</i> ) -> <i>aTime</i> <p></p>")
m0004.addFragment(Paragraph.new("Same as <code>Time::gm</code>, but interprets the values in the local time zone.\n"))
m0004.addFragment(Verbatim.new("Time.local(2000,\"jan\",1,20,15,1)   \#=> Sat Jan 01 20:15:01 CST 2000\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("mktime", "class", "Time.mktime( <i>year, month, day, hour, min, sec, usec</i> ) -> <i>aTime</i>")
m0005.addFragment(Paragraph.new("Synonym for <code>Time::local</code>.\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("new", "class", "Time.new -> <i>aTime</i>")
m0006.addFragment(Paragraph.new("Returns a <code>Time</code> object initialized to the current system time. <b>Note:</b> The object created will be created using the resolution available on your system clock, and so may include fractional seconds.\n"))
m0006.addFragment(Verbatim.new("a = Time.new      \#=> Sun Mar 04 23:30:26 CST 2001\nb = Time.new      \#=> Sun Mar 04 23:30:26 CST 2001\na == b            \#=> false\n\"%.6f\" % a.to_f   \#=> \"983770226.132865\"\n\"%.6f\" % b.to_f   \#=> \"983770226.133372\"\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("now", "class", "Time.now -> <i>aTime</i>")
m0007.addFragment(Paragraph.new("Synonym for <code>Time::new</code>.\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("times", "class", "Time.times -> <i>aStructTms</i>")
m0008.addFragment(Paragraph.new("Returns a <code>Tms</code> structure (see <code>Struct::Tms</code> on page 388) that contains user and system CPU times for this process.\n"))
m0008.addFragment(Verbatim.new("t = Time.times\n[ t.utime, t.stime ]   \#=> [0.0, 0.01]\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("utc", "class", "Time.utc( <i>year <i>[</i>, month, day, hour, min, sec, usec<i>]</i></i> ) -> <i>aTime</i> <br></br>Time.utc( <i>sec, min, hour, day, month, year, wday, yday, isdst, tz</i> ) -> <i>aTime</i>")
m0009.addFragment(Paragraph.new("Synonym for <code>Time::gm</code>.\n"))
m0009.addFragment(Verbatim.new("Time.utc(2000,\"jan\",1,20,15,1)   \#=> Sat Jan 01 20:15:01 UTC 2000\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("+", "instance", "<i>time</i> + <i>aNumeric</i> -> <i>aTime</i>")
m0010.addFragment(Paragraph.new("Addition---Adds some number of seconds (possibly fractional) to <i>time</i> and returns that value as a new time.\n"))
m0010.addFragment(Verbatim.new("t = Time.now         \#=> Sun Mar 04 23:30:26 CST 2001\nt + (60 * 60 * 24)   \#=> Mon Mar 05 23:30:26 CST 2001\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("--", "instance", "<i>time</i> <code>-</code> <i>aTime</i> -> <i>aFloat</i> <br></br><i>time</i> <code>-</code> <i>aNumeric</i> -> <i>aTime</i>")
m0011.addFragment(Paragraph.new("Difference---Returns a new time that represents the difference between two times, or subtracts the given number of seconds in <i>aNumeric</i> from <i>time</i>.\n"))
m0011.addFragment(Verbatim.new("t = Time.now       \#=> Sun Mar 04 23:30:26 CST 2001\nt2 = t + 2592000   \#=> Wed Apr 04 00:30:26 CDT 2001\nt2 - t             \#=> 2592000.0\nt2 - 2592000       \#=> Sun Mar 04 23:30:26 CST 2001\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("<=>", "instance", "<i>time</i> <=> <i>anOtherTime</i> -> -1, 0, +1 <br></br><i>time</i> <=> <i>aNumeric</i> -> -1, 0, +1")
m0012.addFragment(Paragraph.new("Comparison---Compares <i>time</i> with <i>anOtherTime</i> or with <i>aNumeric</i>, which is the number of seconds (possibly fractional) since epoch.\n"))
m0012.addFragment(Verbatim.new("t = Time.now       \#=> Sun Mar 04 23:30:26 CST 2001\nt2 = t + 2592000   \#=> Wed Apr 04 00:30:26 CDT 2001\nt <=> t2           \#=> -1\nt2 <=> t           \#=> 1\nt <=> t            \#=> 0\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("asctime", "instance", "<i>time</i>.asctime -> <i>aString</i>")
m0013.addFragment(Paragraph.new("Returns a canonical string representation of <i>time</i>.\n"))
m0013.addFragment(Verbatim.new("Time.now.asctime   \#=> \"Sun Mar  4 23:30:26 2001\"\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("ctime", "instance", "<i>time</i>.ctime -> <i>aString</i>")
m0014.addFragment(Paragraph.new("Synonym for <code>Time\#asctime</code>.\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("day", "instance", "<i>time</i>.day -> <i>aFixnum</i>")
m0015.addFragment(Paragraph.new("Returns the day of the month (1..n) for <i>time</i>.\n"))
m0015.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.day          \#=> 4\n"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("gmt?", "instance", "<i>time</i>.gmt? -> <code>true</code> or <code>false</code>")
m0016.addFragment(Paragraph.new("Returns <code>true</code> if <i>time</i> represents a time in UTC (GMT).\n"))
m0016.addFragment(Verbatim.new("t = Time.now                        \#=> Sun Mar 04 23:30:26 CST 2001\nt.gmt?                              \#=> false\nt = Time.gm(2000,\"jan\",1,20,15,1)   \#=> Sat Jan 01 20:15:01 UTC 2000\nt.gmt?                              \#=> true\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("gmtime", "instance", "<i>time</i>.gmtime -> <i>time</i>")
m0017.addFragment(Paragraph.new("Converts <i>time</i> to UTC (GMT), modifying the receiver.\n"))
m0017.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.gmt?         \#=> false\nt.gmtime       \#=> Mon Mar 05 05:30:26 UTC 2001\nt.gmt?         \#=> true\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("hour", "instance", "<i>time</i>.hour -> <i>aFixnum</i>")
m0018.addFragment(Paragraph.new("Returns the hour of the day (0..23) for <i>time</i>.\n"))
m0018.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.hour         \#=> 23\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("isdst", "instance", "<i>time</i>.isdst -> <code>true</code> or <code>false</code>")
m0019.addFragment(Paragraph.new("Returns <code>true</code> if <i>time</i> occurs during Daylight Saving Time in its time zone.\n"))
m0019.addFragment(Verbatim.new("t  = Time.local(2000, 7, 1)   \#=> Sat Jul 01 00:00:00 CDT 2000\nt.isdst                       \#=> true\nt2 = Time.local(2000, 1, 1)   \#=> Sat Jan 01 00:00:00 CST 2000\nt2.isdst                      \#=> false\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("localtime", "instance", "<i>time</i>.localtime -> <i>time</i>")
m0020.addFragment(Paragraph.new("Converts <i>time</i> to local time (using the local time zone in effect for this process) modifying the receiver.\n"))
m0020.addFragment(Verbatim.new("t = Time.gm(2000, \"jan\", 1, 20, 15, 1)\nt.gmt?        \#=> true\nt.localtime   \#=> Sat Jan 01 14:15:01 CST 2000\nt.gmt?        \#=> false\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("mday", "instance", "<i>time</i>.mday -> <i>aFixnum</i>")
m0021.addFragment(Paragraph.new("Synonym for <code>Time\#day</code>.\n"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("min", "instance", "<i>time</i>.min -> <i>aFixnum</i>")
m0022.addFragment(Paragraph.new("Returns the minute of the hour (0..59) for <i>time</i>.\n"))
m0022.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.min          \#=> 30\n"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("mon", "instance", "<i>time</i>.mon -> <i>aFixnum</i>")
m0023.addFragment(Paragraph.new("Returns the month of the year (1..12) for <i>time</i>.\n"))
m0023.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.mon          \#=> 3\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("month", "instance", "<i>time</i>.month -> <i>aFixnum</i>")
m0024.addFragment(Paragraph.new("Synonym for <code>Time\#mon</code>.\n"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("sec", "instance", "<i>time</i>.sec -> <i>aFixnum</i>")
m0025.addFragment(Paragraph.new("Returns the second of the minute (0..60)<em>[Yes, seconds really can range from zero to 60. This allows the system to inject leap seconds every now and then to correct for the fact that years are not really a convenient number of hours long.]</em> for <i>time</i>.\n"))
m0025.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.sec          \#=> 26\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("strftime", "instance", "<i>time</i>.strftime( <i>aString</i> ) -> <i>aString</i>")
m0026.addFragment(Paragraph.new("Formats <i>time</i> according to the directives in the given format string. See Table 22.9 on page 402 for the available values. Any text not listed as a directive will be passed through to the output string.\n"))
m0026.addFragment(Verbatim.new("t = Time.now\nt.strftime(\"Printed on %m/%d/%Y\")   \#=> \"Printed on 03/04/2001\"\nt.strftime(\"at %I:%M%p\")            \#=> \"at 11:30PM\"\n"))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("to_a", "instance", "<i>time</i>.to_a -> <i>anArray</i>")
m0027.addFragment(Paragraph.new("Returns a ten-element <i>anArray</i> of values for <i>time</i>: {<code>[ sec, min, hour, day, month, year, wday, yday, isdst, zone ]</code>}. See the individual methods for an explanation of the valid ranges of each value. The ten elements can be passed directly to <code>Time::utc</code> or <code>Time::local</code> to create a new <code>Time</code>.\n"))
m0027.addFragment(Verbatim.new("now = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt = now.to_a     \#=> [26, 30, 23, 4, 3, 2001, 0, 63, false, \"CST\"]\n"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("to_f", "instance", "<i>time</i>.to_f -> <i>aFloat</i>")
m0028.addFragment(Paragraph.new("Returns the value of <i>time</i> as a floating point number of seconds since epoch.\n"))
m0028.addFragment(Verbatim.new("t = Time.now\n\"%10.5f\" % t.to_f   \#=> \"983770226.64529\"\nt.to_i              \#=> 983770226\n"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("to_i", "instance", "<i>time</i>.to_i -> <i>anInteger</i>")
m0029.addFragment(Paragraph.new("Returns the value of <i>time</i> as an integer number of seconds since epoch.\n"))
m0029.addFragment(Verbatim.new("t = Time.now\n\"%10.5f\" % t.to_f   \#=> \"983770226.67497\"\nt.to_i              \#=> 983770226\n"))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("to_s", "instance", "<i>time</i>.to_s -> <i>aString</i>")
m0030.addFragment(Paragraph.new("Returns a string representing <i>time</i>. Equivalent to calling <code>Time\#strftime</code> with a format string of ``<code>%a</code> <code>%b</code> <code>%d</code> <code>%H:%M:%S</code> <code>%Z</code> <code>%Y</code>''.\n"))
m0030.addFragment(Verbatim.new("Time.now.to_s   \#=> \"Sun Mar 04 23:30:26 CST 2001\"\n"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("tv_sec", "instance", "<i>time</i>.tv_sec -> <i>anInteger</i>")
m0031.addFragment(Paragraph.new("Synonym for <code>Time\#to_i</code>.\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("tv_usec", "instance", "<i>time</i>.tv_usec -> <i>anInteger</i>")
m0032.addFragment(Paragraph.new("Synonym for <code>Time\#usec</code>.\n"))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("usec", "instance", "<i>time</i>.usec -> <i>anInteger</i>")
m0033.addFragment(Paragraph.new("Returns just the number of microseconds for <i>time</i>.\n"))
m0033.addFragment(Verbatim.new("t = Time.now        \#=> Sun Mar 04 23:30:26 CST 2001\n\"%10.6f\" % t.to_f   \#=> \"983770226.729373\"\nt.usec              \#=> 729373\n"))
aClass.addMethod(m0033)
m0034 = MethodDesc.new("utc", "instance", "<i>time</i>.utc -> <i>time</i>")
m0034.addFragment(Paragraph.new("Synonym for <code>Time\#gmtime</code>.\n"))
m0034.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.utc?         \#=> false\nt.utc          \#=> Mon Mar 05 05:30:26 UTC 2001\nt.utc?         \#=> true\n"))
aClass.addMethod(m0034)
m0035 = MethodDesc.new("utc?", "instance", "<i>time</i>.utc? -> <code>true</code> or <code>false</code>")
m0035.addFragment(Paragraph.new("Returns <code>true</code> if <i>time</i> represents a time in UTC (GMT).\n"))
m0035.addFragment(Verbatim.new("t = Time.now                        \#=> Sun Mar 04 23:30:26 CST 2001\nt.utc?                              \#=> false\nt = Time.gm(2000,\"jan\",1,20,15,1)   \#=> Sat Jan 01 20:15:01 UTC 2000\nt.utc?                              \#=> true\n"))
aClass.addMethod(m0035)
m0036 = MethodDesc.new("wday", "instance", "<i>time</i>.wday -> <i>aFixnum</i>")
m0036.addFragment(Paragraph.new("Returns an integer representing the day of the week, 0..6, with Sunday == 0.\n"))
m0036.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.wday         \#=> 0\n"))
aClass.addMethod(m0036)
m0037 = MethodDesc.new("yday", "instance", "<i>time</i>.yday -> <i>aFixnum</i>")
m0037.addFragment(Paragraph.new("Returns an integer representing the day of the year, 1..366.\n"))
m0037.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.yday         \#=> 63\n"))
aClass.addMethod(m0037)
m0038 = MethodDesc.new("year", "instance", "<i>time</i>.year -> <i>aFixnum</i>")
m0038.addFragment(Paragraph.new("Returns the year for <i>time</i> (including the century).\n"))
m0038.addFragment(Verbatim.new("t = Time.now   \#=> Sun Mar 04 23:30:26 CST 2001\nt.year         \#=> 2001\n"))
aClass.addMethod(m0038)
m0039 = MethodDesc.new("zone", "instance", "<i>time</i>.zone -> <i>aString</i>")
m0039.addFragment(Paragraph.new("Returns the name of the time zone used for <i>time</i>.\n"))
m0039.addFragment(Verbatim.new("t = Time.gm(2000, \"jan\", 1, 20, 15, 1)\nt.zone   \#=> \"GMT\"\nt = Time.local(2000, \"jan\", 1, 20, 15, 1)\nt.zone   \#=> \"CST\"\n"))
aClass.addMethod(m0039)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
