/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */


#ifndef _hexonet_rfb_OXProperties_h_
#define _hexonet_rfb_OXProperties_h_

#include <xclass/OXTransientFrame.h>
#include "xclass++.h"

class OXTextEntry;
class OXSecretTextEntry;
class OXCheckButton;
class OXSlider;


class Properties
{
    public:
        Properties()
          : acceptSocketConnections( true )
          , displayNumber( 0 )
          , autoDisplayNumber( true )
          , disableLocalControl( false )
          , disableRemoteControl( false )
          , showMousePointer( true )
          , scanOnRequestOnly( true )
          , scanDelay( 150 )
          , useXShm( true )
          , useXTest( true )
        {}

        bool acceptSocketConnections;
        int displayNumber;
        bool autoDisplayNumber;
        char password[9];
        bool disableLocalControl;
        bool disableRemoteControl;
        bool showMousePointer;
        bool scanOnRequestOnly;
        int scanDelay;
        bool useXShm;
        bool useXTest;
};


void readProperties( char *filename, Properties &properties );
void writeProperties( char *filename, Properties &properties );


class OXProperties: public OXTransientFrame
{
    public:
        OXProperties( const OXWindow *_parent, const OXWindow *_main, Properties *_properties );
	virtual ~OXProperties();

        virtual int ProcessMessage( OMessage *msg );
        
        void ApplySettings();
        
    protected:
        LAYOUT_HINTS;
        
        Properties *properties;
        
        OXCheckButton *checkButtonAccept;
        OXTextEntry *entryDisplayNumber;
        OXCheckButton *checkButtonDisplayNumber;
        OXSecretTextEntry *entryPassword;
        OXCheckButton *checkButtonDisableRemoteControl;
        OXCheckButton *checkButtonDisableLocalControl;

        OXCheckButton *checkButtonShowMousePointer;
        OXCheckButton *checkButtonScanOnRequestOnly;
        OXSlider *sliderScanDelay;
        OXCheckButton *checkButtonUseXShm;
        OXCheckButton *checkButtonUseXTest;
};


#endif //_hexonet_rfb_OXProperties_h_
