/*
 *  Copyright (C) 2000-2002 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */


#include "OXAbout.h"

#include "version.h"

OXAbout::OXAbout( const OXWindow *p,
                  const OXWindow *m,
                  char *title,
                  char *progname,
                  char *footnote,
                  const OPicture *logo )
  : OXTransientFrame(p, m, 16, 16, 0)

{
  
  OFontPool *fp = new OFontPool( _client );
  OXFont *font = fp->GetFont("-adobe-helvetica-medium-r-normal-*-11-*-*-*-*-*-*-*");

  ChangeOptions((GetOptions() & ~HORIZONTAL_FRAME) | VERTICAL_FRAME);
  SetWindowName( title );

  OXCompositeFrame *frameLogo = new OXCompositeFrame(this, 60, 20, HORIZONTAL_FRAME | FIXED_HEIGHT);
  ADD_FRAME( this, frameLogo, ( LHINTS_CENTER_Y | LHINTS_EXPAND_X ) );


  OXIcon *icon = new OXIcon( frameLogo, logo,
                             logo->GetWidth(),
                             logo->GetHeight() );
  ADD_FRAME( frameLogo, icon, ( LHINTS_TOP | LHINTS_CENTER_X, 10, 0, 12, 0 ) );

  OString *text = new OString( progname );
  text->Append ( "\n\n"
                 "Copyright (C) 2000-2002\n"
	         "heXoNet Support GmbH, D-66424 Homburg\n"
	         "by Jens Wagner\n"
	         "\n"
		 "For more information see\n"
	         "http://www.hexonet.de/software\n"
                 "http://www.uk.research.att.com/vnc"
	       );
  OXLabel *labelVersion = new OXLabel( frameLogo, text, font );
  ADD_FRAME( frameLogo, labelVersion, ( LHINTS_TOP | LHINTS_RIGHT, 20, 10, 10, 0 ) );


  OXCompositeFrame *frameButton = new OXCompositeFrame(this, 60, 20, HORIZONTAL_FRAME | FIXED_HEIGHT);
  ADD_FRAME( this, frameButton, ( LHINTS_BOTTOM | LHINTS_EXPAND_X, 0, 0, 0, 10 ) );

  OXLabel *labelVNC = new OXLabel( frameButton, new OString( footnote ), font );
  ADD_FRAME( frameButton, labelVNC, ( LHINTS_TOP | LHINTS_LEFT, 10, 0, 12, 0 ) );

  OXButton *buttonOK = new OXTextButton( frameButton, new OString("      OK      "), 101 );
  ADD_FRAME( frameButton, buttonOK, ( LHINTS_TOP | LHINTS_RIGHT, 0, 10, 6, 0 ) );

  buttonOK->Associate( this );

  SetDefaultAcceptButton( buttonOK );
  SetDefaultCancelButton( buttonOK );
  SetFocusOwner( buttonOK );

  frameLogo->Resize( GetDefaultWidth(), labelVersion->GetDefaultHeight()+10);
  frameButton->Resize( GetDefaultWidth(), buttonOK->GetDefaultHeight()+6);
  Resize(GetDefaultSize());

  SetWMSize(_w, _h);

//  SetWMSizeHints(w, h, w, h, 0, 0);

  Move((_client->GetDisplayWidth() - GetWidth()) >> 1,
       (_client->GetDisplayHeight() - GetHeight()) >> 1);

  SetMWMHints(MWM_DECOR_ALL | MWM_DECOR_MAXIMIZE | MWM_DECOR_MENU,
              MWM_FUNC_ALL | MWM_FUNC_MAXIMIZE | MWM_FUNC_RESIZE,
              MWM_INPUT_MODELESS);

  MapSubwindows();
}



int OXAbout::ProcessMessage(OMessage *msg) {
  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (((OWidgetMessage *)msg)->id == 101)) {
        delete this;
      }
  return True;
}
