
#include "FBStreamRecorder.h"
#include <stdlib.h>
#include <string.h>

namespace rfb {


#define MAX_BLOCK_SIZE 8192


FBStreamRecorder::FBStreamRecorder( char* _filename )
  : timer( 0 )
  , timestamp( 0 )
  , pos( 0 )
{
  fd = creat( _filename, S_IRUSR | S_IWUSR );
  buffer = (unsigned char*) malloc( MAX_BLOCK_SIZE );
  writeHeader();
}

FBStreamRecorder::FBStreamRecorder( int _fd )
  : fd( _fd )
  , timer( 0 )
  , timestamp( 0 )
  , pos( 0 )
{
  buffer = (unsigned char*) malloc( MAX_BLOCK_SIZE );
  writeHeader();
}

FBStreamRecorder::~FBStreamRecorder()
{
  flush();
  free( buffer );
  if ( fd > 0 ) close( fd );
}
  
  

void FBStreamRecorder::record( unsigned char *_data, unsigned int _size )
{
  while ( _size ) {
    if ( pos == MAX_BLOCK_SIZE ) flush();
    unsigned int max = MAX_BLOCK_SIZE - pos;
    max = ( max < _size )? max : _size;
    memcpy( buffer + pos, _data, max );
    pos += max;
    _data += max;
    _size -= max;
  }
}
  

void FBStreamRecorder::flush()
{
  if (!pos) return;
  CARD32 size = pos;
  
  write( fd, &size, 4 );
  write( fd, buffer, (size + 3) & 0x7ffffffc );
  write( fd, &timestamp, 4 );
  pos = 0;
}
  
  
void FBStreamRecorder::startTimer()
{
  if ( timer ) return;
  gettimeofday( &tvStart, NULL );
  timer = true;
}

void FBStreamRecorder::stopTimer()
{
  if ( !timer ) return;
  updateTimestamp();
  timer = false;
}

void FBStreamRecorder::updateTimestamp()
{
  if (!timer) return;
  struct timeval tv;
  gettimeofday( &tv, NULL );
  tv.tv_sec -= tvStart.tv_sec;
  tv.tv_usec -= tvStart.tv_usec;
  if ( tv.tv_usec < 0 ) {
    tv.tv_sec--;
    tv.tv_usec += 1000000;
  }
  unsigned int delta = tv.tv_sec * 1000 + tv.tv_usec / 1000;
  
  if ( delta ) {
    flush();
    timestamp = timestamp + delta;
    tvStart.tv_sec += tv.tv_sec;
    tvStart.tv_usec += tv.tv_usec;
    if ( tvStart.tv_usec > 1000000 ) {
      tv.tv_sec++;
      tv.tv_usec -= 1000000;
    }
  }
}


void FBStreamRecorder::writeHeader()
{
  char header[] = "FBS 001.000\n";
  write( fd, header, 12 );
}


} // namespace rfb
