\name{pkgListing-class}
\docType{class}
\alias{pkgListing-class}
\alias{pkgListing}
\alias{packages}
\alias{pkgList}
\alias{repListing}
\alias{pkgNames}
\alias{pkgVersionList}
\alias{getRepURL}
\alias{getRepURL,pkgListing-method}
\alias{downloadRepFile,pkgListing-method}
\alias{getRepEntry,pkgListing-method}
\alias{packages,pkgListing-method}
\alias{pkgList,pkgListing-method}
\alias{pkgVersionList,pkgListing-method}
\alias{repList,pkgListing-method}
\alias{repListing,pkgListing-method}
\alias{show,pkgListing-method}
\alias{summary,pkgListing-method}
\alias{buildPkgListing}
\title{A class to coordinate repository package information}
\description{Coordinates package information from multiple repositories,
  maintaining a list of packages, version information and which versions
  of which packages are from which repositories.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("pkgListing", ...)}.
Also, a convenience function, \code{buildPkgListing} has been provided
which will construct the \code{pkgListing} from just a \code{reposList}
object.
}
\section{Slots}{
  \describe{
    \item{\code{pkgList}:}{A list, detailing packages and versions}
    \item{\code{repList}:}{Object of class \code{"ReposList"}, defines
      the known repositories.}
  }
}

\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "pkgListing")}: Summarizes
      information stored.}
    \item{downloadRepFile}{\code{signature(object = "pkgListing")}:
      Downloads a given file from one of the known repositories.}
    \item{getRepEntry}{\code{signature(object = "pkgListing")}:
      Retrieves a specific \code{repEntry} object from the repository
      listing. }
    \item{getRepURL}{\code{signature(object = "pkgListing")}:
      Retrieves the URL for a specific repository in the object}
    \item{packages}{\code{signature(object = "pkgListing")}: Lists
      available packages in the known repositories.}
    \item{pkgList}{\code{signature(object = "pkgListing")}: Retrieves
      the \code{pkgList} slot }
    \item{pkgVersionList}{\code{signature(object = "pkgListing")}:
      Returns a more formatted list representing the information in the
      \code{pkgList} slot, allowing for the names to be replaced with
      repository names or URLs as well.}
    \item{repListing}{\code{signature(object = "pkgListing")}: Retrieves
    a \code{replisting} slot from one of the known repositories.}
    \item{repList}{\code{signature(object = "pkgListing")}: Retrieves
      the \code{repList} slot.}
    \item{summary}{\code{signature(object = "pkgListing")}: A briefer
      summary of contents then \code{show}}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{buildPkgListing}}, \code{\link{ReposList}}, \code{\link{ReposEntry}}}
\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}
