#!/bin/sh

# makeadir - make a directory with specified owner, group and mode
# $Id: makeadir.sh,v 1.3 2002/05/28 15:54:50 remstats Exp $
# from remstats @@VERSION@@

# Copyright 1999, 2000 (c) Thomas Erskine
# See the COPYRIGHT file with the distribution.

# - - -   Setup   - - -

if [ $# != 4 ] ; then
	echo "usage: $0 owner group mode dir"
	exit 1
fi

owner=$1
group=$2
mode=$3
dir=$4

# - - -   Mainline   - - -

mkdir $dir || \
	(echo "can't mkdir $dir" ; exit 2)
chown $owner $dir || \
	(echo "can't chown $dir" ; exit 2)
chgrp $group $dir || \
	(echo "can't chgrp $dir" ; exit 2)
chmod $mode $dir || \
	(echo "can't chmod $dir" ; exit 2)

exit 0
