#!/usr/bin/python
#
#  Copyright (c) 1998-2001 Sean Reifschneider, tummy.com, ltd.  
#	All Rights Reserved.
#
#  Module which generates CSV (comma seperated value) text-format reports,
#  suitable for import to a spread-sheet.  Is called by the generator.py
#  module *ONLY*.  Requires only being imported by the "stdreport" program,
#  it automatically registers with the generator to generate reports.
#
#  http://www.tummy.com/radiusContext/
#  ftp://ftp.tummy.com/pub/tummy/radiusContext/

import time
import generator
from radiussupp import *
import os

headLine = '"Login Date","Seconds This","Seconds Total","BW In","BW Out",' +  \
		'"Reason"\n'

class gencsv:
	genname = "csv"

	def __init__(self):
		self.out = None
		self.outIndex = None
		self.reportDirName = "."
		self.reportIndexName = "index"
		self.reportSuffix = ".csv"
		self.splitNum = None

	def setSplit(self, split = 0):
		self.splitNum = split

	def reportDir(self, name):
		self.reportDirName = name

	def reportIndex(self, name):
		self.reportIndexName = name

	def Start(self, sesData):
		dir = self.reportDirName + '/'
		if self.splitNum > 0:
			dir = '%s%s/' % ( dir, sesData['userName'][:self.splitNum] )

		try: os.mkdir(dir)
		except os.error: pass
		self.out = open(dir + sesData["userName"] + self.reportSuffix, "w")
		self.out.write(headLine)

	def Stop(self, sesData):
		if self.out != None:
			self.out.close()
			self.out = None

	def Item(self, userData, sesData):
		termReason = sesData.get("Acct-Terminate-Cause", "")
		if not termReason:
			termReason = sesData.get("Ascend-Disconnect-Cause", "")

		self.out.write('"%s",%s,%s,%s,%s,"%s"\n' %
				( sesData["Session-Start-Date"],
				longToStr(sesData["currentTime"]),
				longToStr(userData["timeOn"]),
				longToStr(sesData["currentIn"]),
				longToStr(sesData["currentOut"]),
				termReason ))

	def IndexStart(self):
		self.outIndex = open(self.reportDirName + "/" + self.reportIndexName
				+ self.reportSuffix, "w")
		self.outIndex.write('"User Name","SessionCount","Seconds Total",' +
			'"Seconds Per Day","Seconds Per Ses","BW In","BW Out"\n')

	def IndexStop(self, indexData):
		if self.outIndex != None:
			self.outIndex.close()
			self.outIndex = None

	def IndexItem(self, indexData, userData):
		self.outIndex.write('"%s",%s,%s,%s,%s,%s,%s\n' %
				( userData["userName"], longToStr(userData["sessionCount"]),
				longToStr(userData["timeOn"]),
				longToStr(userData["timeOn"] / userData["numDays"]),
				longToStr(userData["timeOn"] / userData["sessionCount"]),
				longToStr(userData["bytesIn"]),
				longToStr(userData["bytesOut"]) ))
		self.outIndex.flush()

generator.append(gencsv())
