#include <qgl.h>
#include "QGLViewerSceneTreeObjects.h"




STLightList::STLightList(const CList<CLightSource> *pLightList)
/***************************************************************/
{
   m_pLightList = pLightList->getFullDuplicate();
}



STLightList::STLightList(const CLightSource &Light)
/***************************************************************/
{
   m_pLightList = new CList<CLightSource>;
   m_pLightList->insertAsLast(new CLightSource(Light));
}



STLightList::~STLightList()
/***************************************************************/
{
   m_pLightList->clear(1);
   delete m_pLightList;
}



void STLightList::draw()
/***************************************************************/
{
   static GLenum lightIDs[8] = {GL_LIGHT0, GL_LIGHT1, GL_LIGHT2,
                                GL_LIGHT3, GL_LIGHT4, GL_LIGHT5,
                                GL_LIGHT6, GL_LIGHT7};
   static GLfloat mat_ambient[] = {0.2, 0.2, 0.2, 1.0};
   static GLfloat mat_specular[] = {1.0, 1.0, 1.0, 1.0};
   static GLfloat mat_diffuse[4], arfLightPos[4];
   
   int nr = 0;
   GLenum light;
   CListContainer<CLightSource> *pContainer = m_pLightList->getFirst();
   while (pContainer) {
      CLightSource *pLight = pContainer->getObject();
      if (pLight->getStatus() == CLightSource::ON) {
	light = lightIDs[nr];
	switch (pLight->getType()) {
	case CLightSource::CONE_DIFFUSE: {
	  glLightf(light, GL_SPOT_EXPONENT, pLight->getExponent());
	}
	case CLightSource::CONE: {
	  glLightf(light, GL_SPOT_CUTOFF, pLight->getAngle());
	}
	case CLightSource::DIRECTIONAL: {
	  GLfloat arfDirection[3];
	  arfDirection[0] = pLight->getDirection().getX();
	  arfDirection[1] = pLight->getDirection().getY();
	  arfDirection[2] = pLight->getDirection().getZ();
	  glLightfv(light, GL_SPOT_DIRECTION, arfDirection);
	}
	case CLightSource::POINT: { // general settings
	  glLightfv(light, GL_AMBIENT, mat_ambient);

	  mat_diffuse[0] = *pLight->getColor();
	  mat_diffuse[1] = *(pLight->getColor()+1);
	  mat_diffuse[2] = *(pLight->getColor()+2);
	  mat_diffuse[3] = 1.0;
	  glLightfv(light, GL_DIFFUSE, mat_diffuse);

	  glLightfv(light, GL_SPECULAR, mat_specular);

	  arfLightPos[0] = pLight->getPosition().getX();
	  arfLightPos[1] = pLight->getPosition().getY();
	  arfLightPos[2] = pLight->getPosition().getZ();
	  arfLightPos[3] = 1.0;
	  glLightfv(light, GL_POSITION, arfLightPos);

	  //glLightf(light, GL_CONSTANT_ATTENUATION, pLight->getConstantAttenuation());
	  //glLightf(light, GL_LINEAR_ATTENUATION, pLight->getLinearAttenuation());
	  //glLightf(light, GL_QUADRATIC_ATTENUATION, pLight->getQuadraticAttenuation());

	  break;
	}
	}
	if (++nr > 0)
	  glEnable(GL_LIGHTING);
	glEnable(light);
      }
      pContainer = pContainer->getNext();
   }
}



STQGLViewerBoundingBox::STQGLViewerBoundingBox(const CBoundingBox3D &cBBox)
    : CBoundingBox3D(cBBox)
/***************************************************************/
{
   m_nDispList = glGenLists(1);
   glNewList(m_nDispList, GL_COMPILE);

   // Save changed GL states
   glPushAttrib(GL_ENABLE_BIT);
   glPushAttrib(GL_LINE_BIT);
   glPushAttrib(GL_LIGHTING);
   glPushAttrib(GL_CURRENT_BIT); // really needed?

   // Determine bounding box
   ///////////////////////////
   CP3D LowerLeft = getLowerLeft();
   CP3D UpperRight = getUpperRight();

   // Draw box
   /////////////
   glDisable(GL_LIGHTING);
   glLineWidth(1.5);
   glColor3f(1.0, 1.0, 1.0);
 
   glBegin(GL_LINE_LOOP);
   glVertex3f(LowerLeft[0],  LowerLeft[1],  LowerLeft[2]);
   glVertex3f(UpperRight[0], LowerLeft[1],  LowerLeft[2]);
   glVertex3f(UpperRight[0], UpperRight[1], LowerLeft[2]);
   glVertex3f(LowerLeft[0],  UpperRight[1], LowerLeft[2]);
   glEnd();

   glBegin(GL_LINE_LOOP);
   glVertex3f(LowerLeft[0],  LowerLeft[1],  UpperRight[2]);
   glVertex3f(UpperRight[0], LowerLeft[1],  UpperRight[2]);
   glVertex3f(UpperRight[0], UpperRight[1], UpperRight[2]);
   glVertex3f(LowerLeft[0],  UpperRight[1], UpperRight[2]);
   glEnd();

   glBegin(GL_LINES);
   glVertex3f(LowerLeft[0],  LowerLeft[1],  LowerLeft[2]);
   glVertex3f(LowerLeft[0],  LowerLeft[1],  UpperRight[2]);
   glEnd();

   glBegin(GL_LINES);
   glVertex3f(UpperRight[0], LowerLeft[1],  LowerLeft[2]);
   glVertex3f(UpperRight[0], LowerLeft[1],  UpperRight[2]);
   glEnd();

   glBegin(GL_LINES);
   glVertex3f(UpperRight[0], UpperRight[1], LowerLeft[2]);
   glVertex3f(UpperRight[0], UpperRight[1], UpperRight[2]);
   glEnd();
  
   glBegin(GL_LINES);
   glVertex3f(LowerLeft[0],  UpperRight[1], LowerLeft[2]);
   glVertex3f(LowerLeft[0],  UpperRight[1], UpperRight[2]);
   glEnd();

   // Restore GL states
   glPopAttrib();
   glPopAttrib();
   glPopAttrib();
   glPopAttrib();

   glEndList();
};



void STQGLViewerBoundingBox::draw()
/***************************************************************/
{
  if (m_ViewingMode != hidden)
    glCallList(m_nDispList);
}



STDisplayList::~STDisplayList()
/***************************************************************/
{
  glDeleteLists(m_nDispList, 1);
}



void STDisplayList::draw()
/***************************************************************/
{
  static GLfloat col[4];

  if (m_ViewingMode != hidden) {
    col[0] = float(qRed(m_qRgba))/255;
    col[1] = float(qGreen(m_qRgba))/255;
    col[2] = float(qBlue(m_qRgba))/255;
    col[3] = float(qAlpha(m_qRgba))/255;

    glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, col);

    if (glIsList(m_nDispList))
      glCallList(m_nDispList);
  }
}


#if 0
static STProxy _____dummy_for_having_an_instance_this_suxx;

STProxy::STProxy()
/***************************************************************/
{
}



STProxy::~STProxy()
/***************************************************************/
{
}
#endif
