########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/SCore/GroupableObjectMixin.py,v 1.9 2003/01/10 05:39:12 mbrown Exp $
"""
A class that a repository resource class can inherit from in order to
enable it to be a member of a Group

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Server.Common import Schema

class GroupableObjectMixin:
    """
    Other repo resource classes can inherit from this class to enable
    them to be a member of a Group.
    """
    def getGroups(self):
        """
        Returns all the groups that the object is a member of
        """
        self._verifyTx()

        groupUris = map(lambda x:x.subject,
                        self._driver.getSystemModel().complete(
                            None,Schema.GROUP_MEMBER,
                            self._path.absolutePath + ';metadata')
                       )

        res = []
        for groupUri in groupUris:
            group = self.fetchResource(groupUri)
            res.append(group)
            res.extend(group.getGroups())
        return res
