/* *************************************************************************
  Module:        lexincar.c 
  Author:        Matt Simpson
                 Arlington, TX
                 matthewsimpson@home.com
  Date:          August, 2000
  Description:
                 Routines for 'Install Cartridges' popup window.
  Changes:

****************************************************************************
                 COPYRIGHT (C) 1999, 2000 Matt Simpson
                 GNU General Public License
                 See lexgui.c for full notice.
**************************************************************************** */
#include <stdio.h>
#include <gtk/gtk.h>
#include "lexgui.h" 

/* Values of ink type defaults */ 
int lcartype = 1;
int rcartype = 1;
/* -------------------------------------------------------------------------
        accept_type_CB()
   ------------------------------------------------------------------------- */
void accept_type_CB(GtkWidget *widget, msgbox_struct *m)
{
  char message[50];

  clear_msgbox(m); /* clear immediately */
  if(!opendev(m, 2))
  { 
    sprintf(message, "%s", "Sent cartridge types.");
    put_msg(m, message, GREEN, 0);
    send_types(lcartype, rcartype, m);
    clear_message(m); /* clear with timer */
  }
  closedev();
}
/* -------------------------------------------------------------------------
        left_CB()
   ------------------------------------------------------------------------- */
void left_CB(GtkWidget *widget, gint *cartype)
{
  if (GTK_TOGGLE_BUTTON (widget)->active)
    lcartype = *cartype;
}
/* -------------------------------------------------------------------------
        right_CB()
   ------------------------------------------------------------------------- */
void right_CB(GtkWidget *widget, gint *cartype)
{
  if (GTK_TOGGLE_BUTTON (widget)->active)
    rcartype = *cartype;
} 
/* -------------------------------------------------------------------------
        install_CB()
   ------------------------------------------------------------------------- */
void install_CB(GtkWidget *w, msgbox_struct *m)
{
  char message[50];

  clear_msgbox(m); /* clear immediately */
  if(!opendev(m, 2))
  {
    sprintf(message, "%s", "Moving the cartridge cradle...");
    put_msg(m, message, GREEN, 0);
    moveto_install(m);
    clear_message(m); /* clear with timer */
  }
  closedev();
}
/* -------------------------------------------------------------------------
        park_CB()
   ------------------------------------------------------------------------- */
void park_CB(GtkWidget *w, msgbox_struct *m)
{
  char message[50];

  clear_msgbox(m); /* clear immediately */
  if(!opendev(m, 2))
  {
    sprintf(message, "%s", "Sent the park command.");
    put_msg(m, message, GREEN, 0);
    park_cartridges(m);
    clear_message(m); /* clear with timer */
  }
  closedev();
}
/* -------------------------------------------------------------------------
        ic_window()
   ------------------------------------------------------------------------- */
void ic_window(int alreadyopen, topwin_struct *top)
{
  gint i;
  static gint lcar[4] = {0, 1, 2, 3};
  static gint rcar[2] = {0, 1};
  static task_struct icw;
  GtkWidget *ichbox, *leftvbox, *rightvbox, *label;
  GtkWidget *button, *button1, *button2, *hbox, *table;
  GtkWidget *separator;
  GtkTooltips *tooltips;
  GSList *lgroup, *rgroup;
  GtkWidget *lrbutton[4], *rrbutton[2];
  char *lcar_str[] = {"Mono", "Mono High Yield", "Photo", "Photo High Yield"};
  char *rcar_str[] = {"Color", "Color High Yield"};
  char tstring[64];
  GtkWidget *inkbox, *pixmapwidget;
  extern int devtype;

  init_task(top, &icw);
  popup_window(&icw, "Install Cartridges");

  tooltips = gtk_tooltips_new();
  set_tool_color(&tooltips);

  /* For the ink pixmap at the top, added at the end of this function */
  inkbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(icw.vbox_top), inkbox, FALSE, FALSE, 0);
  gtk_widget_show(inkbox);
  make_separator(icw.vbox_top);

  /*---------------------- Step 1 ----------------------------*/
  sprintf(tstring, "%s", "Step 1: Press to access the print cradle.");
  button1 = make_button(icw.vbox_top, tstring);
  gtk_tooltips_set_tip(tooltips, button1, "Cradle will move to left.", NULL);
  gtk_signal_connect(GTK_OBJECT (button1), "clicked",
                     GTK_SIGNAL_FUNC (install_CB), (gpointer)&(icw.msgbox));
  make_separator(icw.vbox_top);
  /*---------------------- Step 2 ----------------------------*/
  table = gtk_table_new(2, 2, FALSE);
  gtk_box_pack_start(GTK_BOX(icw.vbox_top), table, FALSE, FALSE, 0);
  gtk_widget_show(table);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_table_attach(GTK_TABLE(table), hbox, 0, 1, 0, 1,
                   GTK_SHRINK, GTK_EXPAND, 0, 0);
  gtk_widget_show(hbox);

  label = gtk_label_new("Step 2: ");
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  sprintf(tstring, "%s", "Remove the old cartridges.");
  put_mstring(&table, tstring, 0, 1);
  sprintf(tstring, "%s", "Install the new cartridges.");
  put_mstring(&table, tstring, 1, 2);
  
  make_separator(icw.vbox_top);
  /*---------------------- Step 3 ----------------------------*/
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(icw.vbox_top), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  label = gtk_label_new("Step 3: Select the cartridge types:\n");
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  ichbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(icw.vbox_top), ichbox, TRUE, FALSE, 0);
  gtk_widget_show(ichbox);

  leftvbox = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(ichbox), leftvbox, TRUE, FALSE, 0);
  gtk_widget_show(leftvbox);

  label = gtk_label_new("Left Cartridge");
  set_font(&label, 3);  
  gtk_box_pack_start(GTK_BOX(leftvbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  separator = gtk_vseparator_new();
  gtk_box_pack_start (GTK_BOX (ichbox), separator, FALSE, FALSE, 10);
  gtk_widget_show (separator);

  rightvbox = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(ichbox), rightvbox, TRUE, FALSE, 0);
  gtk_widget_show(rightvbox);
  
  label = gtk_label_new("Right Cartridge");
  set_font(&label, 3);  
  gtk_box_pack_start(GTK_BOX(rightvbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  lgroup = NULL; /* REQUIRED */  
  for(i = 0; i < 4; i++)
  {
    lrbutton[i] = gtk_radio_button_new_with_label(lgroup, lcar_str[i]); 
    gtk_box_pack_start(GTK_BOX(leftvbox), lrbutton[i], FALSE, FALSE, 0);
    lgroup = gtk_radio_button_group(GTK_RADIO_BUTTON(lrbutton[i]));  
    set_color(&(lrbutton[i]), YELLOW, BG, ACTIVE);
    gtk_signal_connect(GTK_OBJECT(lrbutton[i]), "toggled",
                       GTK_SIGNAL_FUNC(left_CB), (gpointer)&(lcar[i]));
    gtk_widget_show(lrbutton[i]);
  }
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lrbutton[lcartype]), TRUE);

  rgroup = NULL; /* REQUIRED */
  for(i = 0; i < 2; i++)
  {
    rrbutton[i] = gtk_radio_button_new_with_label(rgroup, rcar_str[i]);
    gtk_box_pack_start(GTK_BOX(rightvbox), rrbutton[i], FALSE, FALSE, 0);
    rgroup = gtk_radio_button_group(GTK_RADIO_BUTTON(rrbutton[i]));
    set_color(&(rrbutton[i]), YELLOW, BG, ACTIVE);
    gtk_signal_connect(GTK_OBJECT(rrbutton[i]), "toggled",
                       GTK_SIGNAL_FUNC(right_CB), (gpointer)&(rcar[i]));
    gtk_widget_show(rrbutton[i]);
  }
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rrbutton[rcartype]), TRUE);

  blank(icw.vbox_top);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(icw.vbox_top), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_with_label("Accept Cartridge Types");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT (button), "clicked",
                     GTK_SIGNAL_FUNC (accept_type_CB), (gpointer)&(icw.msgbox));
  gtk_widget_show(button);
  make_separator(icw.vbox_top);
  /*---------------------- Step 4 ----------------------------*/
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(icw.vbox_top), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  label = gtk_label_new("");
  gtk_label_set_text(GTK_LABEL(label),
    "Do not park when creating command scripts "
    "for a remote printer. Instead, create a separate "
    "script with the park command to use afterwards.");
  gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_FILL);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label); 

  blank(icw.vbox_top);

  sprintf(tstring, "%s", "Step 4: Press to park the cradle.");
  button2 = make_button(icw.vbox_top, tstring);
  gtk_tooltips_set_tip(tooltips, button2, "Cradle will move to right.", NULL);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
                        GTK_SIGNAL_FUNC (park_CB), (gpointer)&(icw.msgbox));
  make_separator(icw.vbox_top);
  /*---------------------- Step 5 ----------------------------*/
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(icw.vbox_top), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  label = gtk_label_new("");
  gtk_label_set_text(GTK_LABEL(label),
    "Step 5: After closing this window, reset the ink level\n"
    "gauges and align the cartridges from the main menu.");
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  make_separator(icw.vbox_top);
  /*----------------------------------------------------------*/
  make_messageBox(&(icw.vbox_top), &(icw.msgbox));

  /* For the X delete */
  gtk_signal_connect(GTK_OBJECT(icw.tasktop), "delete_event",
                     GTK_SIGNAL_FUNC(deleteTWX), (gpointer)&icw);
  gtk_widget_show(icw.tasktop);
  /* Add the ink pixmap to this window */
  pixmapwidget = create_nbpix(&icw.tasktop, 0);
  gtk_box_pack_start(GTK_BOX(inkbox), pixmapwidget, TRUE, FALSE, 0);

  if(!devtype && alreadyopen)
    pop_set_note(&icw, NULL);
}
