%define name        printtool
%define version     4.5
%define rel         1
%define prefix      /usr

Name: %{name}
Version: %{version}
Release: %{rel}
Copyright: GPL
Summary: A printer configuration tool with a graphical user interface.
Group: Applications/Publishing
Source0: %{name}-%{version}.tar.gz
Requires: ghostscript tcl tk printfilters >= 2.0 lpr >= 0.70 
Conflicts: printconf-gui
BuildArchitectures: noarch
BuildRoot: /var/tmp/%{name}-root

%description
The printtool is a printer configuration tool with a graphical user
interface.  Printtool can manage both local and remote printers,
including Windows (SMB) and NetWare (NCP) printers.

Printtool should be installed so that you can manage local and remote
printers.

%prep
%setup

%build
./configure --prefix=%{_prefix}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_prefix}
make DESTDIR="$RPM_BUILD_ROOT" install

find "$RPM_BUILD_ROOT" -type f -print \
  | sed -e "s@^${RPM_BUILD_ROOT}@@" > rpm.filelist

%clean
rm -rf $RPM_BUILD_ROOT

%files -f rpm.filelist

%changelog
* Thu Dec 21 2000 Mark Pruett <mpruett@valinux.com>
- Made several changes to partially sync with RH printtool 3.54:
- added 2 paper sizes to $paper_size_list
- changed default value of $auto_ascps_trans from "NO" to "YES"
- the addition of a 'set_printcap_field $i "lpd_bounce=" "true"'
  line to printcap entries for remote printers (I'd wager
  an LPRng thing).
- Added USB /dev/usb/lp[0-2] detection
- Things I did NOT change:
- filters symlinked rather than copied to spool directory in 3.54
- .cfg files are "chown lp.lp" in 3.54 
- .cfg files are now "chmod 600", rather than "chmod 755" in 3.54
  (These last two are handled already by calling "checkpc -f"
  if they're running LPRng.)

* Thu Feb 10 2000 Bill Nottingham <notting@redhat.com>
- ppa support <f.d.m.haldane@mciworld.com>

* Tue Oct  5 1999 Bill Nottingham <notting@redhat.com>
- fix printer port detection

* Tue Aug 24 1999 Bill Nottingham <notting@redhat.com>
- don't put spaces in a spool directory

* Sat Aug 21 1999 Bill Nottingham <notting@redhat.com>
- add ignore stuff

* Mon Aug  7 1999 Bill Nottingham <notting@redhat.com>
- should require ghostscript

* Fri Mar 19 1999 Bill Nottingham <notting@redhat.com>
- text changes

* Mon Feb  9 1999 Bill Nottingham <notting@redhat.com>
- uniprint support, courtesy Osamu Aoki

* Mon Dec 28 1998 Bill Nottingham <notting@redhat.com>
- ditto

* Tue Dec  8 1998 Bill Nottingham <notting@redhat.com>
- oops. fix SMB printers, again

* Wed Nov 18 1998 Bill Nottingham <notting@redhat.com>
- add workgroup field for SMB printers

* Fri Oct  2 1998 Bill Nottingham <notting@redhat.com>
- fix typo

* Thu Sep  9 1998 Bill Nottingham <notting@redhat.com>
- fix description

* Thu Sep  2 1998 Bill Nottingham <notting@redhat.com>
- added NCP support

* Sun Aug 23 1998 Jeff Johnson <jbj@redhat.com>
- /etc/rc.d/init.d/lpd.init is now just lpd. (problem #768)

* Mon Aug 17 1998 Jeff Johnson <jbj@redhat.com>
- build root

* Wed Nov 26 1997 Michael Fulbright <msf@redhat.com>
- fixed to print warning if smbclient not installed

* Fri Nov  7 1997 Michael Fulbright <msf@redhat.com>
- added wmconfig

* Wed Nov  5 1997 Michael Fulbright <msf@redhat.com>
- fixed add/edit printer boxes with new packing cause old one broke bad

* Wed Oct 22 1997 Michael Fulbright <msf@redhat.com>
- put nice new xpm icon in place
- fixed up help titles
- corrected lots of misspellings

* Tue Oct 14 1997 Erik Troan <ewt@redhat.com>
- made a noarch package

* Tue Apr 22 1997 Michael Fulbright <msf@redhat.com>
- Moved to version 3.2.
- Fixed problem with EXTRA_GS_OPIONS

* Fri Mar 12 1997 Michael Fulbright <msf@redhat.com>
- Moved up to version 3.1.
- Added support for mpage - allows nup printing and adjustable margins.
- Simplified configuraion for stair-stepped text and sending EOF.
- Fixed PS filter to send a '\004' instead of a '\014' as EOF character.

* Wed Mar 12 1997 Michael Fulbright <msf@redhat.com>
- Added A4 paper test page support. 

* Fri Mar  7 1997 Michael Fulbright <msf@redhat.com>
- Split print filters off into rh-printfilters package.
- Removed some undesirable debug messages.

* Fri Feb 14 1997 Michael Fulbright <msf@redhat.com>
- Fixed a 'sh -x' left in head of smbprint script
