// ------------------------------------------------------------------------- //
// $Id: math.cpp,v 1.4 2004/01/27 20:20:39 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include "common.h"

void m33::makeRotate(float xangle, float yangle, float zangle)
{
	float xcos = cos(xangle);
	float xsin = sin(xangle);
	float ycos = cos(yangle);
	float ysin = sin(yangle);
	float zcos = cos(zangle);
	float zsin = sin(zangle);

	set(
		// First row
		zsin * xsin * ysin + zcos * ycos,
		zcos * xsin * ysin - zsin * ycos,
		xcos * ysin,

		// Second row
		zsin * xcos,
		zcos * xcos, 
		-xsin,

		// Third row
		zsin * xsin * ycos - zcos * ysin,
		zcos * xsin * ycos + zsin * ysin,
		xcos * ycos
   );
}

void m44::makeRotate(v3 dir, float angle)
{
	float c = cos(angle);
	float s = sin(angle);
	float t = 1 - c;
	float x = dir.x();
	float y = dir.y();
	float z = dir.z();

	set (  t*x*x+c, t*x*y+s*z, t*x*z-s*y, 0.0f,
	     t*x*y-s*z,   t*y*y+c, t*y*z+s*x, 0.0f,
		 t*x*z+s*y, t*y*z-s*x,   t*z*z+c, 0.0f,
		      0.0f,      0.0f,      0.0f, 1.0f);
}

std::ostream& operator<< (std::ostream& os, const m33& m)
{
	os << m._f[0][0] << " " << m._f[0][1] << " " << m._f[0][2] << std::endl;
	os << m._f[1][0] << " " << m._f[1][1] << " " << m._f[1][2] << std::endl;
	os << m._f[2][0] << " " << m._f[2][1] << " " << m._f[2][2] << std::endl;
	return os;
}

std::ostream& operator<< (std::ostream& os, const m44& m)
{
	os<<m._f[0][0]<<" "<<m._f[0][1]<<" "<<m._f[0][2]<<" "<<m._f[0][3] << std::endl;
	os<<m._f[1][0]<<" "<<m._f[1][1]<<" "<<m._f[1][2]<<" "<<m._f[1][3] << std::endl;
	os<<m._f[2][0]<<" "<<m._f[2][1]<<" "<<m._f[2][2]<<" "<<m._f[2][3] << std::endl;
	os<<m._f[3][0]<<" "<<m._f[3][1]<<" "<<m._f[3][2]<<" "<<m._f[3][3] << std::endl;
	return os;
}

// ------------------------------------------------------------------------- //

