/*
 * $Id: pmud.h,v 1.1.1.1 2001/12/07 11:31:44 sleemburg Exp $
 * 
 * definitions for pmud - PMU daemon for Linux/PPC on Powerbooks.
 *
 * Copyright 1999 Paul Mackerras, Stephan Leemburg.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version
 *  2 of the License, or (at your option) any later version.
 *
 * $Log: pmud.h,v $
 * Revision 1.1.1.1  2001/12/07 11:31:44  sleemburg
 * Initial CVS import of the unreleased pmud-0.8 to apmud (new project name
 * because of a name clash at sourceforge.net).
 *
 * Revision 1.4  2000/05/11 14:54:24  stephan
 * pmud 0.6 changes
 *
 * Revision 1.3  2000/03/09 18:58:53  stephan
 * path of powerstatus was incorrectly prepended with /etc/power
 *
 * Revision 1.2  2000/03/09 13:00:25  stephan
 * paths changed, some apm definitions for future work.
 *
 * Revision 1.1  2000/01/06 13:48:19  stephan
 * Initial revision
 *
 */
#ifndef HDR_PMUD_H
#define HDR_PMUD_H

#include <syslog.h>

#define PMUD_VERSION		"0.10"
#define PMU_FILE		"/dev/pmu"
#define PMU_DEVFS_FILE		"/dev/misc/pmu"
#define ADB_FILE		"/dev/adb"
#define FB0_FILE		"/dev/fb0"
#define POWERDIR		"/etc/power"
#define POWERLEVEL_SCRIPT	POWERDIR "/pwrctl"
#define POWER_FILE		POWERDIR "/levels"
#define SOCKET_FILE		POWERDIR "/control"
#define CONSOLE_FILE		"/dev/console"

#ifndef POWERSTATUS_FILE
#define POWERSTATUS_FILE	"/etc/powerstatus"
#endif

#define PORT			879

#define PMU_VERSION_3400	9
#define PMU_VERSION_WALLSTREET	10	/* a (good) guess */
#define PMU_VERSION_LOMBARD	11
#define PMU_VERSION_KEYLARGO	12	/* another guess */

#define PMU_FACILITY		LOG_DAEMON
#define PMU_SYSLOG_OPTIONS	(LOG_CONS|LOG_PID)
#define PMUD_SERVICE		"pmud"

#ifndef APM_FILE
#define APM_FILE		POWERDIR "/apm"
#endif

#define APM_FAKEFLAGS		0x02
#define APM_CRITICAL		10
#define APM_LOW			30
#define APM_THRESHOLD		600

/* 
 * Go to sleep if we have <= this many seconds of battery power remaining 
 * 
 * 7 minutes seems the best time for my G3 Wallstreet Powerbook (Stephan)
 */

#define CRITICAL_TIMELEFT	420

/* Require power to be critically low for this many seconds before sleeping */

#define CRITICAL_TIME		15

#define BEEP_TIME 150
#define BEEP_OK   1000
#define BEEP_WARN 2000
#define BEEP_ERR  4000

#endif /* HDR_PMUD_H */
