Summary:   Portable Forth Environment
Name:	   pfe
Version:   0.33.34
Release:   1sfnet
Serial:	   1
Copyright: LGPL
Group:	   Development/Languages
URL:	   http://sourceforge.net/projects/pfe
Vendor:	   Guido Draheim <guidod@gmx.de>
Source0:   http://prdownloads.sf.net/%{name}/%{name}-%{version}.tar.bz2
BuildRoot: /var/tmp/%{name}-%{version}-%{release}

Distribution:	Sourceforge
Packager:	Guido Draheim <guidod@gmx.de>

%package doc
Summary:	PFE Documentation
Group:		Development/Libraries

%package sfnet
Summary:	PFE Sourceforge Documentation
Group:		Development/Libraries

%package devel
Summary:	PFE Development Headers
Group:		Development/Libraries
Requires:       pfe

%package regs
Summary:	PFE Documentation
Group:		Development/Libraries

%package fig
Summary:	PFE Documentation
Group:		Development/Libraries

%package forth
Summary:	PFE Documentation
Group:		Development/Libraries
Requires:       pfe-regs

%package call
Summary:	PFE Documentation
Group:		Development/Libraries

%package calls
Summary:	PFE Documentation
Group:		Development/Libraries

%package fast
Summary:	PFE Documentation
Group:		Development/Libraries

%description
The Portable Forth Environment is a Forth Engine completly written in C.
It has a module concept so it can be extended with C modules. It is
completly multithreaded, and implements the DPANS94, the proposed ANSI
standard on Forth.

%description doc
The Portable Forth Environment.
The documentation, mostly autogenerated.

%description sfnet
The Portable Forth Environment.
The documentation, mostly autogenerated, for http://PFE.sf.net

%description devel
The Portable Forth Environment.
The header file for compiling extension modules for
use by the forth engine, or for compiling applications
that use the forth library as a scripting engine.

The headers are namespace clean, i.e. all symbols
have a prefix to distinguish them from other symbols.

%description regs
The Portable Forth Environment - regs=all variant.

%description fig
The Portable Forth Environment - fig=1 variant.

%description forth
The Portable Forth Environment - without-modules variant.

%description call
The Portable Forth Environment - --with-call-threading variant

%description calls
The Portable Forth Environment - --with-sbr-threading variant

%description fast
The Portable Forth Environment - --with-sbrx-threading variant

%prep
%setup
# we do not have --enable-all anymore, sorry
for variant in regs fig forth call calls fast . ; do
# % configure - the configure macro has weird interactions with pfe builds
CFLAGS="$RPM_OPT_FLAGS" sh configure \
       --prefix=%{_prefix} \
        --bindir=%{_bindir} \
        --sbindir=%{_sbindir} \
        --sysconfdir=%{_sysconfdir} \
        --datadir=%{_datadir} \
        --includedir=%{_includedir} \
        --libdir=%{_libdir} \
        --libexecdir=%{_libexecdir} \
        --localstatedir=%{_localstatedir} \
        --sharedstatedir=%{_sharedstatedir} \
        --mandir=%{_mandir} \
        --infodir=%{_infodir} \
   --with-variant=$variant
done

%build
make 
make check
make docs

%install
rm -rf %{buildroot}
make install-all DESTDIR=%{buildroot}
make install-doc DESTDIR=%{buildroot}
make install-docs DESTDIR=%{buildroot}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%clean
rm -rf %{buildroot}

%files
     %defattr(-,root,root)
%doc ChangeLog
     %{_bindir}/%{name}
     %{_libdir}/lib%{name}-0.so.*
%dir %{_libdir}/%{name}
     %{_libdir}/%{name}/*.so
%dir %{_datadir}/%{name}
     %{_datadir}/%{name}/*
     %{_mandir}/*

%files doc
#    %config(noreplace) %{prefix}/%{name}.conf
%dir %{_infodir}/../doc/%name
     %{_infodir}/../doc/%name/*

%files sfnet
#    %config(noreplace) %{prefix}/%{name}.conf
     %{_infodir}/../groups/*

%files devel
     %{_bindir}/*-config
%dir %{_prefix}/include/%{name}
     %{_prefix}/include/%{name}/*
     %{_libdir}/lib%{name}.so
     %{_libdir}/lib%{name}.la
     %{_libdir}/lib%{name}.a
     %{_libdir}/%{name}/*.la
     %{_libdir}/%{name}/*.a
     %{_libdir}/pkgconfig/*.pc

%files fig
#    %defattr(-,root,root)
     %{_bindir}/%{name}-fig
     %{_libdir}/lib%{name}*-fig*
%dir %{_libdir}/%{name}-fig
     %{_libdir}/%{name}-fig/*

%files regs
#    %defattr(-,root,root)
     %{_bindir}/%{name}-regs
     %{_libdir}/lib%{name}*-regs*
%dir %{_libdir}/%{name}-regs
     %{_libdir}/%{name}-regs/*

%files forth
#    %defattr(-,root,root)
     %{_bindir}/%{name}-regs-forth

%files call
#    %defattr(-,root,root)
     %{_bindir}/%{name}-call
     %{_libdir}/lib%{name}*-call*
%dir %{_libdir}/%{name}-call
     %{_libdir}/%{name}-call/*

%files calls
#    %defattr(-,root,root)
     %{_bindir}/%{name}-calls

%files fast
#    %defattr(-,root,root)
     %{_bindir}/%{name}-fast
     %{_libdir}/lib%{name}*-fast*
%dir %{_libdir}/%{name}-fast
     %{_libdir}/%{name}-fast/*

%post doc
echo "PFE Documentation installed"
# %{_prefix}/%{name}-install && /bin/true

