/* axpy.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "petscmat.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define mataxpy_ PMATAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define mataxpy_ pmataxpy
#else
#define mataxpy_ pmataxpy_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define mataxpy_ MATAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define mataxpy_ mataxpy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matshift_ PMATSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matshift_ pmatshift
#else
#define matshift_ pmatshift_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matshift_ MATSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matshift_ matshift
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matdiagonalset_ PMATDIAGONALSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matdiagonalset_ pmatdiagonalset
#else
#define matdiagonalset_ pmatdiagonalset_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matdiagonalset_ MATDIAGONALSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matdiagonalset_ matdiagonalset
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define mataypx_ PMATAYPX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define mataypx_ pmataypx
#else
#define mataypx_ pmataypx_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define mataypx_ MATAYPX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define mataypx_ mataypx
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcomputeexplicitoperator_ PMATCOMPUTEEXPLICITOPERATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcomputeexplicitoperator_ pmatcomputeexplicitoperator
#else
#define matcomputeexplicitoperator_ pmatcomputeexplicitoperator_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcomputeexplicitoperator_ MATCOMPUTEEXPLICITOPERATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcomputeexplicitoperator_ matcomputeexplicitoperator
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL mataxpy_( PetscScalar *a,Mat X,Mat Y,MatStructure *str, int *ierr ){
*ierr = MatAXPY(a,
	(Mat)PetscToPointer( (X) ),
	(Mat)PetscToPointer( (Y) ),*str);
}
void PETSC_STDCALL matshift_( PetscScalar *a,Mat Y, int *ierr ){
*ierr = MatShift(a,
	(Mat)PetscToPointer( (Y) ));
}
void PETSC_STDCALL matdiagonalset_(Mat Y,Vec D,InsertMode *is, int *ierr ){
*ierr = MatDiagonalSet(
	(Mat)PetscToPointer( (Y) ),
	(Vec)PetscToPointer( (D) ),*is);
}
void PETSC_STDCALL mataypx_( PetscScalar *a,Mat X,Mat Y, int *ierr ){
*ierr = MatAYPX(a,
	(Mat)PetscToPointer( (X) ),
	(Mat)PetscToPointer( (Y) ));
}
void PETSC_STDCALL matcomputeexplicitoperator_(Mat inmat,Mat *mat, int *ierr ){
*ierr = MatComputeExplicitOperator(
	(Mat)PetscToPointer( (inmat) ),mat);
}
#if defined(__cplusplus)
}
#endif
