/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.ChannelException;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.MethodCall;
import org.javagroups.blocks.RpcDispatcher;
import org.javagroups.blocks.VoteException;
import org.javagroups.blocks.VotingListener;
import org.javagroups.log.Trace;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VotingAdapter
implements MessageListener,
MembershipListener {
    public static final int VOTE_ANY = 0;
    public static final int VOTE_ALL = 1;
    public static final int VOTE_MAJORITY = 2;
    private static final int PROCESS_CONTINUE = 0;
    private static final int PROCESS_SKIP = 1;
    private static final int PROCESS_BREAK = 2;
    private RpcDispatcher rpcDispatcher;
    private HashSet suspectedNodes;
    private boolean blocked;
    private boolean closed;
    private Set voteListeners;
    private VotingListener[] listeners;
    static /* synthetic */ Class class$java$lang$Object;

    public boolean vote(Object decree, int consensusType, long timeout) throws ChannelException {
        if (this.closed) {
            throw new ChannelException("Channel was closed.");
        }
        int mode = 2;
        switch (consensusType) {
            case 1: {
                mode = 2;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 2: {
                mode = 3;
                break;
            }
            default: {
                mode = 2;
            }
        }
        try {
            Class<?> clazz = this.getClass();
            Class[] classArray = new Class[1];
            Class clazz2 = class$java$lang$Object;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Object = VotingAdapter.class$("[Ljava.lang.Object;", false);
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("localVote", classArray);
            MethodCall methodCall = new MethodCall(method, new Object[]{decree});
            RspList responses = this.rpcDispatcher.callRemoteMethods(null, methodCall, mode, timeout);
            return this.processResponses(responses, consensusType);
        }
        catch (NoSuchMethodException nsmex) {
            Trace.error("VotingAdapter.vote()", "Could not find method localVote(Object). " + nsmex.toString());
            throw new UnsupportedOperationException("Cannot execute voting because of absence of " + this.getClass().getName() + ".localVote(Object) method.");
        }
    }

    private final boolean processResponses(RspList responses, int consensusType) throws ChannelException {
        if (responses == null) {
            return false;
        }
        boolean voteResult = false;
        int totalPositiveVotes = 0;
        int totalNegativeVotes = 0;
        int i = 0;
        while (i < responses.size()) {
            Rsp response = (Rsp)responses.elementAt(i);
            switch (this.checkResponse(response)) {
                case 1: {
                    break;
                }
                case 2: {
                    return false;
                }
                default: {
                    VoteResult result = (VoteResult)response.getValue();
                    totalPositiveVotes += result.getPositiveVotes();
                    totalNegativeVotes += result.getNegativeVotes();
                }
            }
            ++i;
        }
        switch (consensusType) {
            case 1: {
                boolean bl = false;
                if (totalNegativeVotes == 0 && totalPositiveVotes > 0) {
                    bl = true;
                }
                voteResult = bl;
                break;
            }
            case 0: {
                boolean bl = false;
                if (totalPositiveVotes > 0) {
                    bl = true;
                }
                voteResult = bl;
                break;
            }
            case 2: {
                boolean bl = false;
                if (totalPositiveVotes > totalNegativeVotes) {
                    bl = true;
                }
                voteResult = bl;
            }
        }
        return voteResult;
    }

    private final int checkResponse(Rsp response) throws ChannelException {
        if (!response.wasReceived()) {
            return 2;
        }
        if (response.wasSuspected()) {
            return 1;
        }
        Object object = response.getValue();
        if (object instanceof Throwable) {
            throw new ChannelException("Node " + response.getSender() + " is faulty.");
        }
        if (object == null) {
            return 1;
        }
        if (!(object instanceof VoteResult)) {
            String faultClass = object.getClass().getName();
            throw new ChannelException("Node " + response.getSender() + " generated fault (class " + faultClass + ')');
        }
        if (object instanceof FailureVoteResult) {
            Trace.error("VotingAdapter.checkResponse()", ((FailureVoteResult)object).getReason());
            return 2;
        }
        return 0;
    }

    public void viewAccepted(View newView) {
        Iterator iterator = this.suspectedNodes.iterator();
        while (iterator.hasNext()) {
            Address suspectedNode = (Address)iterator.next();
            if (!newView.containsMember(suspectedNode)) continue;
            iterator.remove();
        }
        this.blocked = false;
    }

    public void suspect(Address suspected) {
        this.suspectedNodes.add(suspected);
    }

    public void block() {
        this.blocked = true;
    }

    public byte[] getState() {
        return null;
    }

    public void receive(Message msg) {
    }

    public void setState(byte[] state) {
    }

    public boolean vote(Object decree, long timeout) throws ChannelException {
        return this.vote(decree, 1, timeout);
    }

    public void addVoteListener(VotingListener listener) {
        this.voteListeners.add(listener);
        this.listeners = this.voteListeners.toArray(new VotingListener[this.voteListeners.size()]);
    }

    public void removeVoteListener(VotingListener listener) {
        this.voteListeners.remove(listener);
        this.listeners = this.voteListeners.toArray(new VotingListener[this.voteListeners.size()]);
    }

    public VoteResult localVote(Object decree) {
        VoteResult voteResult = new VoteResult();
        int i = 0;
        while (i < this.listeners.length) {
            VotingListener listener = this.listeners[i];
            try {
                voteResult.addVote(listener.vote(decree));
            }
            catch (VoteException vex) {
            }
            catch (RuntimeException ex) {
                Trace.error("VotingAdapter.localVote()", ex.toString());
                return new FailureVoteResult(ex.getMessage());
            }
            ++i;
        }
        return voteResult;
    }

    public static String getConsensusStr(int consensusType) {
        switch (consensusType) {
            case 1: {
                return "VOTE_ALL";
            }
            case 0: {
                return "VOTE_ANY";
            }
            case 2: {
                return "VOTE_MAJORITY";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.suspectedNodes = new HashSet();
        this.blocked = false;
        this.voteListeners = new HashSet();
    }

    public VotingAdapter(Channel channel) {
        this.this();
        this.rpcDispatcher = new RpcDispatcher(channel, (MessageListener)this, (MembershipListener)this, (Object)this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class VoteResult
    implements Serializable {
        private int positiveVotes;
        private int negativeVotes;

        public void addVote(boolean vote) {
            if (vote) {
                ++this.positiveVotes;
            } else {
                ++this.negativeVotes;
            }
        }

        public int getPositiveVotes() {
            return this.positiveVotes;
        }

        public int getNegativeVotes() {
            return this.negativeVotes;
        }

        public String toString() {
            return "VoteResult: up=" + this.positiveVotes + ", down=" + this.negativeVotes;
        }

        private final /* synthetic */ void this() {
            this.positiveVotes = 0;
            this.negativeVotes = 0;
        }

        public VoteResult() {
            this.this();
        }
    }

    public static class FailureVoteResult
    extends VoteResult {
        private String reason;

        public String getReason() {
            return this.reason;
        }

        public FailureVoteResult(String reason) {
            this.reason = reason;
        }
    }
}

